/*
 * Decompiled with CFR 0.152.
 */
package net.sf.click.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sf.click.Page;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.exception.ParseErrorException;

public class ErrorReport {
    private static final String[] JAVA_KEYWORDS = new String[]{"package", "import", "class", "public", "protected", "private", "extends", "implements", "return", "if", "while", "for", "do", "else", "try", "new", "void", "catch", "throws", "throw", "static", "final", "break", "continue", "super", "finally", "true", "false", "true;", "false;", "null", "boolean", "int", "char", "long", "float", "double", "short"};
    protected int columnNumber;
    protected final Throwable error;
    protected int lineNumber;
    protected final boolean isParseError;
    protected final boolean isProductionMode;
    protected final Page page;
    protected final String sourceName;
    protected LineNumberReader sourceReader;

    public ErrorReport(Throwable error, Page page, boolean isProductionMode) {
        this.page = page;
        this.error = error;
        this.isProductionMode = isProductionMode;
        this.isParseError = error instanceof ParseErrorException;
        if (this.isParseError) {
            ParseErrorException pee = (ParseErrorException)error;
            this.sourceName = pee.getTemplateName();
            this.lineNumber = pee.getLineNumber();
            this.columnNumber = pee.getColumnNumber();
            ServletContext context = page.getContext().getServletContext();
            InputStream is = context.getResourceAsStream(pee.getTemplateName());
            this.sourceReader = new LineNumberReader(new InputStreamReader(is));
        } else {
            this.sourceName = null;
            this.columnNumber = -1;
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.getCause().printStackTrace(pw);
            StringTokenizer tokenizer = new StringTokenizer(sw.toString(), "\n");
            try {
                tokenizer.nextToken();
                String line = tokenizer.nextToken();
                int nameStart = line.indexOf("at ");
                int nameEnd = line.indexOf("(");
                nameEnd = line.lastIndexOf(".", nameEnd);
                if (line.indexOf("$") != -1) {
                    nameEnd = line.indexOf("$");
                }
                String classname = line.substring(nameStart + 3, nameEnd);
                int lineStart = line.indexOf(":");
                if (lineStart != -1) {
                    int lineEnd = line.indexOf(")");
                    String linenumber = line.substring(lineStart + 1, lineEnd);
                    this.lineNumber = Integer.parseInt(linenumber);
                    String filename = "/" + classname.replace('.', '/') + ".java";
                    this.sourceReader = this.getJavaSourceReader(filename);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getErrorReport() {
        if (this.isProductionMode()) {
            Locale locale = this.page.getContext().getLocale();
            ResourceBundle bundle = ResourceBundle.getBundle("click-control", locale);
            return bundle.getString("production-error-message");
        }
        StringBuffer buffer = new StringBuffer(10240);
        Throwable cause = this.getCause();
        HttpServletRequest request = this.page.getContext().getRequest();
        buffer.append("<div id='errorReport' class='errorReport'>\n");
        buffer.append("<table border='1' cellspacing='1' cellpadding='4' width='100%'>");
        if (this.isParseError()) {
            buffer.append("<tr><td colspan='2' style='color:white; background-color: navy; font-weight: bold'>Page Parsing Error</td></tr>");
            buffer.append("<tr><td width='12%'><b>Source</b></td><td>");
            buffer.append(this.getSourceName());
            buffer.append("</td></tr>");
        } else {
            buffer.append("<tr><td colspan='2' style='color:white; background-color: navy; font-weight: bold'>Exception</td></tr>");
            buffer.append("<tr><td width='12%'><b>Class</b></td><td>");
            buffer.append(cause.getClass().getName());
            buffer.append("</td></tr>");
        }
        buffer.append("<tr><td valign='top' width='12%'><b>Message</b></td><td>");
        buffer.append(this.getMessage());
        buffer.append("</td></tr>");
        if (this.getSourceReader() != null) {
            buffer.append("<tr><td valign='top' colspan='2'>\n");
            buffer.append(this.getRenderedSource());
            buffer.append("</td></tr>");
        }
        if (!this.isParseError()) {
            buffer.append("<tr><td valign='top' colspan='2'>\n");
            buffer.append(this.getStackTrace());
            buffer.append("</td></tr>");
        }
        buffer.append("</table>");
        buffer.append("<br/>");
        buffer.append("<table border='1' cellspacing='1' cellpadding='4' width='100%'>");
        buffer.append("<tr><td colspan='2' style='color:white; background-color: navy; font-weight: bold'>Page</td></tr>");
        buffer.append("<tr><td width='12%'><b>Classname</b></td><td>");
        buffer.append(this.page.getClass().getName());
        buffer.append("</td></tr>");
        buffer.append("<tr><td width='12%'><b>Path</b></td><td>");
        buffer.append(this.page.getPath());
        buffer.append("</td></tr>");
        buffer.append("<tr><td><b width='12%'>Template</b></td><td>");
        buffer.append(this.page.getTemplate());
        buffer.append("</td></tr>");
        buffer.append("</table>");
        buffer.append("<br/>");
        buffer.append("<table border='1' cellspacing='1' cellpadding='4' width='100%'>");
        buffer.append("<tr><td colspan='2' style='color:white; background-color: navy; font-weight: bold'>Request</td></tr>");
        TreeMap<String, Object> requestAttributes = new TreeMap<String, Object>();
        Enumeration attributeNames = request.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String name = attributeNames.nextElement().toString();
            requestAttributes.put(name, request.getAttribute(name));
        }
        buffer.append("<tr><td width='12%' valign='top'><b>Attributes</b></td><td>");
        this.writeMap(requestAttributes, buffer);
        buffer.append("</td></tr>");
        buffer.append("<tr><td width='12%'><b>Auth Type</b></td><td>");
        buffer.append(request.getAuthType());
        buffer.append("</td></tr>");
        buffer.append("<tr><td width='12%'><b>Context Path</b></td><td>");
        buffer.append("<a href='");
        buffer.append(request.getContextPath());
        buffer.append("'>");
        buffer.append(request.getContextPath());
        buffer.append("</a>");
        buffer.append("</td></tr>");
        TreeMap<String, String> requestHeaders = new TreeMap<String, String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = headerNames.nextElement().toString();
            requestHeaders.put(name, request.getHeader(name));
        }
        buffer.append("<tr><td width='12%' valign='top'><b>Headers</b></td><td>");
        this.writeMap(requestHeaders, buffer);
        buffer.append("</td></tr>");
        buffer.append("<tr><td width='12%'><b>Query</b></td><td>");
        buffer.append(request.getQueryString());
        buffer.append("</td></tr>");
        buffer.append("<tr><td width='12%'><b>Method</b></td><td>");
        buffer.append(request.getMethod());
        buffer.append("</td></tr>");
        TreeMap<String, String> requestParams = new TreeMap<String, String>();
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String name = paramNames.nextElement().toString();
            requestParams.put(name, request.getParameter(name));
        }
        buffer.append("<tr><td width='12%' valign='top'><b>Parameters</b></td><td>");
        this.writeMap(requestParams, buffer);
        buffer.append("</td></tr>");
        buffer.append("<tr><td width='12%'><b>Remote User</b></td><td>");
        buffer.append(request.getRemoteUser());
        buffer.append("</td></tr>");
        buffer.append("<tr><td width='12%' valign='top'><b>URI</b></td><td>");
        buffer.append("<a href='");
        buffer.append(request.getRequestURI());
        buffer.append("'>");
        buffer.append(request.getRequestURI());
        buffer.append("</a>");
        buffer.append("</td></tr>");
        buffer.append("<tr><td><b width='12%'>URL</b></td><td>");
        buffer.append("<a href='");
        buffer.append(request.getRequestURL());
        buffer.append("'>");
        buffer.append(request.getRequestURL());
        buffer.append("</a>");
        buffer.append("</td></tr>");
        TreeMap<String, Object> sessionAttributes = new TreeMap<String, Object>();
        if (this.page.getContext().hasSession()) {
            HttpSession session = request.getSession();
            attributeNames = session.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                String name = attributeNames.nextElement().toString();
                sessionAttributes.put(name, session.getAttribute(name));
            }
        }
        buffer.append("<tr><td width='12%' valign='top'><b>Session</b></td><td>");
        this.writeMap(sessionAttributes, buffer);
        buffer.append("</td></tr>");
        buffer.append("</table>\n");
        buffer.append("</div>\n");
        return buffer.toString();
    }

    public Throwable getCause() {
        Throwable cause = null;
        if (this.error instanceof ServletException) {
            cause = ((ServletException)this.error).getRootCause();
            if (cause == null) {
                cause = this.error.getCause();
            }
        } else {
            cause = this.error.getCause();
        }
        if (cause == null) {
            cause = this.error;
        }
        return cause;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public boolean isParseError() {
        return this.isParseError;
    }

    public boolean isProductionMode() {
        return this.isProductionMode;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getMessage() {
        if (this.isParseError()) {
            String message = this.error.getMessage();
            int startIndex = message.indexOf(10);
            int endIndex = message.lastIndexOf("...");
            String parseMsg = message.substring(startIndex + 1, endIndex);
            parseMsg = StringEscapeUtils.escapeHtml((String)parseMsg);
            parseMsg = StringUtils.replace((String)parseMsg, (String)"...", (String)", &nbsp;");
            return parseMsg;
        }
        Throwable cause = this.getCause();
        String value = cause.getMessage() != null ? cause.getMessage() : "null";
        return StringEscapeUtils.escapeHtml((String)value);
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public LineNumberReader getSourceReader() {
        return this.sourceReader;
    }

    protected LineNumberReader getJavaSourceReader(String filename) throws FileNotFoundException {
        InputStream is = this.page.getClass().getResourceAsStream(filename);
        if (is != null) {
            return new LineNumberReader(new InputStreamReader(is));
        }
        String rootPath = this.page.getContext().getServletContext().getRealPath("/");
        String webInfPath = rootPath + File.separator + "WEB-INF";
        File sourceFile = null;
        File webInfDir = new File(webInfPath);
        if (webInfDir.isDirectory() && webInfDir.canRead()) {
            File[] dirList = webInfDir.listFiles();
            for (int i = 0; i < dirList.length; ++i) {
                String sourcePath;
                File file = dirList[i];
                if (!file.isDirectory() || !file.canRead() || !(sourceFile = new File(sourcePath = file.toString() + filename)).isFile() || !sourceFile.canRead()) continue;
                FileInputStream fis = new FileInputStream(sourceFile);
                return new LineNumberReader(new InputStreamReader(fis));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getRenderedSource() {
        StringBuffer buffer = new StringBuffer(5120);
        buffer.append("<pre style='font-family: Courier New, courier;'>");
        if (this.sourceReader == null) {
            buffer.append("Source is not available.</span>");
            return buffer.toString();
        }
        String errorLineStyle = "style='background-color:yellow;'";
        String errorCharSpan = "<span style='color:red;text-decoration:underline;font-weight:bold;'>";
        try {
            String line = this.sourceReader.readLine();
            while (line != null) {
                if (this.skipLine()) {
                    line = this.sourceReader.readLine();
                    continue;
                }
                boolean isErrorLine = this.sourceReader.getLineNumber() == this.lineNumber;
                buffer.append("<div ");
                if (isErrorLine) {
                    buffer.append("style='background-color:yellow;'");
                }
                buffer.append(">");
                String lineStr = "" + this.sourceReader.getLineNumber();
                int numberSpace = 3 - lineStr.length();
                for (int i = 0; i < numberSpace; ++i) {
                    buffer.append(" ");
                }
                if (isErrorLine) {
                    buffer.append("<b>");
                }
                buffer.append(this.sourceReader.getLineNumber());
                if (isErrorLine) {
                    buffer.append("</b>");
                }
                buffer.append(":  ");
                if (isErrorLine) {
                    if (this.isParseError()) {
                        StringBuffer htmlLine = new StringBuffer(line.length() * 2);
                        for (int i = 0; i < line.length(); ++i) {
                            if (i == this.getColumnNumber() - 1) {
                                htmlLine.append("<span style='color:red;text-decoration:underline;font-weight:bold;'>");
                                htmlLine.append(line.charAt(i));
                                htmlLine.append("</span>");
                                continue;
                            }
                            htmlLine.append(line.charAt(i));
                        }
                        buffer.append(htmlLine.toString());
                    } else {
                        buffer.append(this.getRenderJavaLine(line));
                    }
                } else if (this.isParseError()) {
                    buffer.append(StringEscapeUtils.escapeHtml((String)line));
                } else {
                    buffer.append(this.getRenderJavaLine(line));
                }
                buffer.append("</div>");
                line = this.sourceReader.readLine();
            }
        }
        catch (IOException ioe) {
            buffer.append("Could not load page source: ");
            buffer.append(StringEscapeUtils.escapeHtml((String)ioe.toString()));
        }
        finally {
            try {
                this.sourceReader.close();
            }
            catch (IOException ioe) {}
        }
        buffer.append("</pre>");
        return buffer.toString();
    }

    protected String getStackTrace() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.getCause().printStackTrace(pw);
        StringBuffer buffer = new StringBuffer(sw.toString().length() + 80);
        buffer.append("<pre><tt style='font-size:10pt;'>");
        buffer.append(StringEscapeUtils.escapeHtml((String)sw.toString().trim()));
        buffer.append("</tt></pre>");
        return buffer.toString();
    }

    protected void writeMap(Map map, StringBuffer buffer) {
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            buffer.append(key);
            buffer.append("=");
            Object value = map.get(key);
            if (value != null) {
                buffer.append(StringEscapeUtils.escapeHtml((String)value.toString()));
            } else {
                buffer.append("null");
            }
            buffer.append("</br>");
        }
        if (map.isEmpty()) {
            buffer.append("&nbsp;");
        }
    }

    protected String getRenderJavaLine(String line) {
        line = StringEscapeUtils.escapeHtml((String)line);
        for (int i = 0; i < JAVA_KEYWORDS.length; ++i) {
            String keyword = JAVA_KEYWORDS[i];
            line = this.renderJavaKeywords(line, keyword);
        }
        return line;
    }

    protected String renderJavaKeywords(String line, String keyword) {
        String markupToken = "<span style='color:#7f0055;font-weight:bold;'>" + keyword + "</span>";
        if ((line = StringUtils.replace((String)line, (String)(" " + keyword + " "), (String)(" " + markupToken + " "))).startsWith(keyword)) {
            line = markupToken + line.substring(keyword.length());
        }
        if (line.endsWith(keyword)) {
            line = line.substring(0, line.length() - keyword.length()) + markupToken;
        }
        return line;
    }

    protected boolean skipLine() {
        int errorLine;
        int currentLine = this.getSourceReader().getLineNumber();
        return Math.abs(currentLine - (errorLine = this.getLineNumber())) > 10;
    }
}

