/*
 * Decompiled with CFR 0.152.
 */
package net.sf.click.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.click.control.DateField;
import net.sf.click.control.Field;
import net.sf.click.control.FieldSet;
import net.sf.click.control.Form;
import net.sf.click.control.HiddenField;
import net.sf.click.control.Label;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;

public class ClickUtils {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;

    public static Document buildDocument(InputStream inputStream) {
        return ClickUtils.buildDocument(inputStream, null);
    }

    public static Document buildDocument(InputStream inputStream, EntityResolver entityResolver) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (entityResolver != null) {
                builder.setEntityResolver(entityResolver);
            }
            return builder.parse(inputStream);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error parsing XML", ex);
        }
    }

    public static void close(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void copyFormToObject(Form form, Object object, boolean debug) {
        if (form == null) {
            throw new IllegalArgumentException("Null form parameter");
        }
        if (object == null) {
            throw new IllegalArgumentException("Null object parameter");
        }
        String objectClassname = object.getClass().getName();
        objectClassname = objectClassname.substring(objectClassname.lastIndexOf(".") + 1);
        Method[] methods = object.getClass().getMethods();
        List fieldList = ClickUtils.getFormFields(form);
        int size = fieldList.size();
        for (int i = 0; i < size; ++i) {
            Field field = (Field)fieldList.get(i);
            if (field.getName().equals("form_name")) continue;
            String setterName = ClickUtils.toSetterName(field.getName());
            Method method = null;
            for (int j = 0; j < methods.length; ++j) {
                if (!setterName.equals(methods[j].getName())) continue;
                method = methods[j];
                break;
            }
            if (method != null) {
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (parameterTypes.length == 1) {
                    java.util.Date date;
                    Class<?> paramClass = parameterTypes[0];
                    Object paramObject = null;
                    if (paramClass == (class$java$lang$String == null ? ClickUtils.class$("java.lang.String") : class$java$lang$String)) {
                        paramObject = field.getValue();
                    } else if (paramClass == (class$java$lang$Integer == null ? ClickUtils.class$("java.lang.Integer") : class$java$lang$Integer)) {
                        if (!StringUtils.isBlank((String)field.getValue())) {
                            paramObject = Integer.valueOf(field.getValue());
                        }
                    } else if (paramClass == (class$java$lang$Boolean == null ? ClickUtils.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                        if (!StringUtils.isBlank((String)field.getValue())) {
                            paramObject = Boolean.valueOf(field.getValue());
                        }
                    } else if (paramClass == (class$java$lang$Double == null ? ClickUtils.class$("java.lang.Double") : class$java$lang$Double)) {
                        if (!StringUtils.isBlank((String)field.getValue())) {
                            paramObject = Double.valueOf(field.getValue());
                        }
                    } else if (paramClass == (class$java$lang$Float == null ? ClickUtils.class$("java.lang.Float") : class$java$lang$Float)) {
                        if (!StringUtils.isBlank((String)field.getValue())) {
                            paramObject = Float.valueOf(field.getValue());
                        }
                    } else if (paramClass == (class$java$lang$Long == null ? ClickUtils.class$("java.lang.Long") : class$java$lang$Long)) {
                        if (!StringUtils.isBlank((String)field.getValue())) {
                            paramObject = Long.valueOf(field.getValue());
                        }
                    } else if (paramClass == (class$java$lang$Short == null ? ClickUtils.class$("java.lang.Short") : class$java$lang$Short)) {
                        if (!StringUtils.isBlank((String)field.getValue())) {
                            paramObject = Short.valueOf(field.getValue());
                        }
                    } else if (paramClass == (class$java$util$Date == null ? ClickUtils.class$("java.util.Date") : class$java$util$Date)) {
                        if (field instanceof DateField) {
                            paramObject = ((DateField)field).getDate();
                        }
                    } else if (paramClass == (class$java$sql$Date == null ? ClickUtils.class$("java.sql.Date") : class$java$sql$Date)) {
                        if (field instanceof DateField && (date = ((DateField)field).getDate()) != null) {
                            paramObject = new Date(date.getTime());
                        }
                    } else if (paramClass == (class$java$sql$Time == null ? ClickUtils.class$("java.sql.Time") : class$java$sql$Time)) {
                        if (field instanceof DateField && (date = ((DateField)field).getDate()) != null) {
                            paramObject = new Time(date.getTime());
                        }
                    } else if (paramClass == (class$java$sql$Timestamp == null ? ClickUtils.class$("java.sql.Timestamp") : class$java$sql$Timestamp) && field instanceof DateField && (date = ((DateField)field).getDate()) != null) {
                        paramObject = new Timestamp(date.getTime());
                    }
                    Object[] params = new Object[]{paramObject};
                    try {
                        method.invoke(object, params);
                        if (!debug) continue;
                        String msg = "[Click] [debug] Form -> " + objectClassname + "." + method.getName() + " : " + paramObject;
                        System.out.println(msg);
                    }
                    catch (Exception e) {
                        if (!debug) continue;
                        String msg = "[Click] [debug] Error incurred invoking " + objectClassname + "." + method.getName() + "() with " + paramObject + " error: " + e.toString();
                        System.out.println(msg);
                    }
                    continue;
                }
                if (!debug) continue;
                String msg = "[Click] [debug] " + objectClassname + "." + method.getName() + "() method has invalid number of parameters";
                System.out.println(msg);
                continue;
            }
            if (!debug) continue;
            String msg = "[Click] [debug] " + objectClassname + "." + setterName + "() method not found";
            System.out.println(msg);
        }
    }

    public static void copyObjectToForm(Object object, Form form, boolean debug) {
        if (object == null) {
            throw new IllegalArgumentException("Null object parameter");
        }
        if (form == null) {
            throw new IllegalArgumentException("Null form parameter");
        }
        String objectClassname = object.getClass().getName();
        objectClassname = objectClassname.substring(objectClassname.lastIndexOf(".") + 1);
        Method[] methods = object.getClass().getMethods();
        List fieldList = ClickUtils.getFormFields(form);
        int size = fieldList.size();
        for (int i = 0; i < size; ++i) {
            Field field = (Field)fieldList.get(i);
            if (field.getName().equals("form_name")) continue;
            String getterName = ClickUtils.toGetterName(field.getName());
            String isGetterName = ClickUtils.toIsGetterName(field.getName());
            Method method = null;
            for (int j = 0; j < methods.length; ++j) {
                if (getterName.equals(methods[j].getName())) {
                    method = methods[j];
                    break;
                }
                if (!isGetterName.equals(methods[j].getName())) continue;
                method = methods[j];
                break;
            }
            if (method != null) {
                String msg;
                try {
                    Object result = method.invoke(object, null);
                    if (debug) {
                        msg = "[Click] [debug] Form <- " + objectClassname + "." + method.getName() + " : " + result;
                        System.out.println(msg);
                    }
                    if (result == null) continue;
                    if (field instanceof DateField && result instanceof java.util.Date) {
                        DateField dateField = (DateField)field;
                        dateField.setDate((java.util.Date)result);
                        continue;
                    }
                    if (field instanceof HiddenField) {
                        field.setValue(result);
                        continue;
                    }
                    field.setValue(result.toString());
                }
                catch (Exception e) {
                    if (!debug) continue;
                    msg = "[Click] [debug] Error incurred invoking " + objectClassname + "." + method.getName() + "() error: " + e.toString();
                    System.out.println(msg);
                }
                continue;
            }
            if (!debug) continue;
            String msg = "[Click] [debug] " + objectClassname + "." + getterName + "() method not found";
            System.out.println(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encode(Object object) throws IOException {
        if (object == null) {
            throw new IllegalArgumentException("null object parameter");
        }
        if (!(object instanceof Serializable)) {
            throw new IllegalArgumentException("parameter not Serializable");
        }
        ByteArrayOutputStream bos = null;
        GZIPOutputStream gos = null;
        ObjectOutputStream oos = null;
        try {
            bos = new ByteArrayOutputStream();
            gos = new GZIPOutputStream(bos);
            oos = new ObjectOutputStream(gos);
            oos.writeObject(object);
            oos.close();
        }
        catch (Throwable throwable) {
            ClickUtils.close(oos);
            ClickUtils.close(gos);
            ClickUtils.close(bos);
            throw throwable;
        }
        ClickUtils.close(oos);
        ClickUtils.close(gos);
        ClickUtils.close(bos);
        Base64 base64 = new Base64();
        try {
            byte[] byteData = base64.encode(bos.toByteArray());
            return new String(byteData);
        }
        catch (Throwable t) {
            String message = "error occured Base64 encoding: " + object + " : " + t;
            throw new IOException(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object decode(String string) throws ClassNotFoundException, IOException {
        Object object;
        Base64 base64 = new Base64();
        byte[] byteData = null;
        try {
            byteData = base64.decode(string.getBytes());
        }
        catch (Throwable t) {
            String message = "error occured Base64 decoding: " + string + " : " + t;
            throw new IOException(message);
        }
        ByteArrayInputStream bis = null;
        GZIPInputStream gis = null;
        ObjectInputStream ois = null;
        try {
            bis = new ByteArrayInputStream(byteData);
            gis = new GZIPInputStream(bis);
            ois = new ObjectInputStream(gis);
            object = ois.readObject();
        }
        catch (Throwable throwable) {
            ClickUtils.close(ois);
            ClickUtils.close(gis);
            ClickUtils.close(bis);
            throw throwable;
        }
        ClickUtils.close(ois);
        ClickUtils.close(gis);
        ClickUtils.close(bis);
        return object;
    }

    public static boolean invokeListener(Object listener, String method) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener parameter");
        }
        if (method == null) {
            throw new IllegalArgumentException("Null method parameter");
        }
        Method targetMethod = null;
        try {
            targetMethod = listener.getClass().getMethod(method, null);
            Object result = targetMethod.invoke(listener, null);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            String msg = "Invalid listener method, missing boolean return type: " + targetMethod;
            throw new RuntimeException(msg);
        }
        catch (InvocationTargetException ite) {
            Throwable e = ite.getTargetException();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Exception) {
                String msg = "Exception occured invoking public method: " + targetMethod;
                throw new RuntimeException(msg, e);
            }
            if (e instanceof Error) {
                String msg = "Error occured invoking public method: " + targetMethod;
                throw new RuntimeException(msg, e);
            }
            String msg = "Error occured invoking public method: " + targetMethod;
            throw new RuntimeException(msg, e);
        }
        catch (Exception e) {
            String msg = "Exception occured invoking public method: " + targetMethod;
            throw new RuntimeException(msg, e);
        }
    }

    public static List getFormFields(Form form) {
        if (form == null) {
            throw new IllegalArgumentException("Null form parameter");
        }
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (int i = 0; i < form.getFieldList().size(); ++i) {
            Field field = (Field)form.getFieldList().get(i);
            if (field instanceof FieldSet) {
                FieldSet fieldSet = (FieldSet)field;
                for (int j = 0; j < fieldSet.getFieldList().size(); ++j) {
                    Field fieldSetField = (Field)fieldSet.getFieldList().get(j);
                    if (fieldSetField instanceof Label) continue;
                    fieldList.add(fieldSetField);
                }
                continue;
            }
            if (field instanceof Label) continue;
            fieldList.add(field);
        }
        return fieldList;
    }

    public static String getResourcePath(HttpServletRequest request) {
        String path = (String)request.getAttribute("javax.servlet.include.servlet_path");
        String info = (String)request.getAttribute("javax.servlet.include.path_info");
        if (path == null) {
            path = request.getServletPath();
            info = request.getPathInfo();
        }
        if (info != null) {
            path = path + info;
        }
        return path;
    }

    public static String toGetterName(String property) {
        StringBuffer buffer = new StringBuffer(property.length() + 3);
        buffer.append("get");
        buffer.append(Character.toUpperCase(property.charAt(0)));
        buffer.append(property.substring(1));
        return buffer.toString();
    }

    public static String toIsGetterName(String property) {
        StringBuffer buffer = new StringBuffer(property.length() + 3);
        buffer.append("is");
        buffer.append(Character.toUpperCase(property.charAt(0)));
        buffer.append(property.substring(1));
        return buffer.toString();
    }

    public static String toName(String label) {
        if (label == null) {
            throw new IllegalArgumentException("Null label parameter");
        }
        boolean doneFirstLetter = false;
        boolean lastCharBlank = false;
        boolean hasWhiteSpace = label.indexOf(32) != -1;
        StringBuffer buffer = new StringBuffer(label.length());
        int size = label.length();
        for (int i = 0; i < size; ++i) {
            char aChar = label.charAt(i);
            if (aChar != ' ') {
                if (!Character.isJavaIdentifierPart(aChar)) continue;
                if (lastCharBlank) {
                    if (doneFirstLetter) {
                        buffer.append(Character.toUpperCase(aChar));
                        lastCharBlank = false;
                        continue;
                    }
                    buffer.append(Character.toLowerCase(aChar));
                    lastCharBlank = false;
                    doneFirstLetter = true;
                    continue;
                }
                if (doneFirstLetter) {
                    if (hasWhiteSpace) {
                        buffer.append(Character.toLowerCase(aChar));
                        continue;
                    }
                    buffer.append(aChar);
                    continue;
                }
                buffer.append(Character.toLowerCase(aChar));
                doneFirstLetter = true;
                continue;
            }
            lastCharBlank = true;
        }
        return buffer.toString();
    }

    public static String toSetterName(String property) {
        StringBuffer buffer = new StringBuffer(property.length() + 3);
        buffer.append("set");
        buffer.append(Character.toUpperCase(property.charAt(0)));
        buffer.append(property.substring(1));
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

