/*
 * Decompiled with CFR 0.152.
 */
package net.sf.click.util;

import javax.servlet.ServletContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogChute;

public class ClickLogger
implements LogChute {
    public static final String LOG_LEVEL = (class$net$sf$click$util$ClickLogger == null ? (class$net$sf$click$util$ClickLogger = ClickLogger.class$("net.sf.click.util.ClickLogger")) : class$net$sf$click$util$ClickLogger).getName() + ".LOG_LEVEL";
    public static final String LOG_TO = (class$net$sf$click$util$ClickLogger == null ? (class$net$sf$click$util$ClickLogger = ClickLogger.class$("net.sf.click.util.ClickLogger")) : class$net$sf$click$util$ClickLogger).getName() + ".LOG_TO";
    private static final String LOG_INSTANCE = (class$net$sf$click$util$ClickLogger == null ? (class$net$sf$click$util$ClickLogger = ClickLogger.class$("net.sf.click.util.ClickLogger")) : class$net$sf$click$util$ClickLogger).getName() + ".LOG_INSTANCE";
    private static final String[] LEVELS = new String[]{" [trace] ", " [debug] ", " [info ] ", " [warn ] ", " [error] "};
    protected int logLevel = 0;
    protected final String name;
    protected ServletContext servletContext = null;
    static /* synthetic */ Class class$net$sf$click$util$ClickLogger;
    static /* synthetic */ Class class$javax$servlet$ServletContext;

    public ClickLogger(String name) {
        this.name = name;
    }

    public ClickLogger() {
        this.name = "Velocity";
    }

    public void init(RuntimeServices rs) throws Exception {
        Integer level;
        String logto = (String)rs.getApplicationAttribute((Object)LOG_TO);
        if ("servlet".equals(logto)) {
            this.servletContext = (ServletContext)rs.getApplicationAttribute((Object)(class$javax$servlet$ServletContext == null ? (class$javax$servlet$ServletContext = ClickLogger.class$("javax.servlet.ServletContext")) : class$javax$servlet$ServletContext).getName());
        }
        if (!((level = (Integer)rs.getApplicationAttribute((Object)LOG_LEVEL)) instanceof Integer)) {
            String msg = "Could not retrieve LOG_LEVEL from Runtime attributes";
            throw new IllegalStateException(msg);
        }
        this.setLevel(level);
        rs.setApplicationAttribute((Object)LOG_INSTANCE, (Object)this);
    }

    public static ClickLogger getInstance(VelocityEngine ve) {
        return (ClickLogger)ve.getApplicationAttribute((Object)LOG_INSTANCE);
    }

    public void log(int level, String message) {
        this.log(level, message, null);
    }

    public void log(int level, String message, Throwable error) {
        if (level < this.logLevel) {
            return;
        }
        StringBuffer buffer = new StringBuffer(80);
        buffer.append("[");
        buffer.append(this.name);
        buffer.append("]");
        buffer.append(LEVELS[level + 1]);
        buffer.append(message);
        if (this.servletContext != null) {
            if (error != null) {
                this.servletContext.log(buffer.toString(), error);
            } else {
                this.servletContext.log(buffer.toString());
            }
        } else if (error != null) {
            System.out.print(buffer.toString());
            error.printStackTrace(System.out);
        } else {
            System.out.println(buffer.toString());
        }
    }

    public boolean isLevelEnabled(int level) {
        return this.logLevel >= level;
    }

    public void setLevel(int level) {
        this.logLevel = level;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void debug(Object message) {
        this.log(0, String.valueOf(message), null);
    }

    public void debug(Object message, Throwable error) {
        this.log(0, String.valueOf(message), error);
    }

    public void error(Object message) {
        this.log(3, String.valueOf(message), null);
    }

    public void error(Object message, Throwable error) {
        this.log(3, String.valueOf(message), error);
    }

    public void info(Object message) {
        this.log(1, String.valueOf(message), null);
    }

    public void trace(Object message) {
        this.log(-1, String.valueOf(message), null);
    }

    public void trace(Object message, Throwable error) {
        this.log(-1, String.valueOf(message), error);
    }

    public void warn(Object message) {
        this.log(2, String.valueOf(message), null);
    }

    public void warn(Object message, Throwable error) {
        this.log(2, String.valueOf(message), error);
    }

    public boolean isDebugEnabled() {
        return this.logLevel <= 0;
    }

    public boolean isInfoEnabled() {
        return this.logLevel <= 1;
    }

    public boolean isTraceEnabled() {
        return this.logLevel <= -1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

