/*
 * Decompiled with CFR 0.152.
 */
package net.sf.click.control;

import net.sf.click.control.Field;
import net.sf.click.util.HtmlStringBuffer;

public class TextField
extends Field {
    private static final long serialVersionUID = 6187190854708434969L;
    protected int maxLength = 0;
    protected int minLength = 0;
    protected int size = 20;

    public TextField(String label) {
        super(label);
    }

    public TextField(String name, String label) {
        super(name, label);
    }

    public TextField(String label, boolean required) {
        super(label);
        this.setRequired(required);
    }

    public TextField(String label, int size) {
        super(label);
        this.setSize(size);
    }

    public TextField(String name, String label, int size) {
        super(name, label);
        this.setSize(size);
    }

    public TextField() {
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getType() {
        return "text";
    }

    public boolean onProcess() {
        this.value = this.getRequestValue();
        if (!this.validate()) {
            return true;
        }
        int length = this.value.length();
        if (length > 0) {
            if (this.getMinLength() > 0 && length < this.getMinLength()) {
                Object[] args = new Object[]{this.getLabel(), new Integer(this.getMinLength())};
                this.setError(this.getMessage("field-minlength-error", args));
                return true;
            }
            if (this.getMaxLength() > 0 && length > this.getMaxLength()) {
                Object[] args = new Object[]{this.getLabel(), new Integer(this.getMaxLength())};
                this.setError(this.getMessage("field-maxlength-error", args));
                return true;
            }
            return this.invokeListener();
        }
        if (this.isRequired()) {
            this.setError(this.getMessage("field-required-error", this.getLabel()));
        }
        return true;
    }

    public String toString() {
        HtmlStringBuffer buffer = new HtmlStringBuffer(96);
        buffer.elementStart("input");
        buffer.appendAttribute("type", this.getType());
        buffer.appendAttribute("name", this.getName());
        buffer.appendAttribute("id", this.getId());
        buffer.appendAttribute("value", this.getValue());
        buffer.appendAttribute("size", this.getSize());
        buffer.appendAttribute("title", this.getTitle());
        if (this.getMaxLength() > 0) {
            buffer.appendAttribute("maxlength", this.getMaxLength());
        }
        if (this.hasAttributes()) {
            buffer.appendAttributes(this.getAttributes());
        }
        if (this.isDisabled()) {
            buffer.appendAttributeDisabled();
        }
        if (this.isReadonly()) {
            buffer.appendAttributeReadonly();
        }
        if (!this.isValid()) {
            buffer.appendAttribute("class", "error");
        } else if (this.isDisabled()) {
            buffer.appendAttribute("class", "disabled");
        }
        buffer.elementEnd();
        return buffer.toString();
    }
}

