/*
 * Decompiled with CFR 0.152.
 */
package net.sf.click.control;

import net.sf.click.control.Field;
import net.sf.click.util.HtmlStringBuffer;

public class TextArea
extends Field {
    private static final long serialVersionUID = 850919582013675611L;
    protected int cols = 20;
    protected int maxLength = 0;
    protected int minLength = 0;
    protected int rows = 3;

    public TextArea(String label) {
        super(label);
    }

    public TextArea(String name, String label) {
        super(name, label);
    }

    public TextArea(String label, boolean required) {
        super(label);
        this.setRequired(required);
    }

    public TextArea(String label, int cols, int rows) {
        super(label);
        this.setCols(cols);
        this.setRows(rows);
    }

    public TextArea(String name, String label, int cols, int rows) {
        super(name, label);
        this.setCols(cols);
        this.setRows(rows);
    }

    public TextArea() {
    }

    public int getCols() {
        return this.cols;
    }

    public void setCols(int cols) {
        this.cols = cols;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public boolean onProcess() {
        this.value = this.getRequestValue();
        if (!this.validate()) {
            return true;
        }
        int length = this.value.length();
        if (length > 0) {
            if (this.getMinLength() > 0 && length < this.getMinLength()) {
                Object[] args = new Object[]{this.getLabel(), new Integer(this.getMinLength())};
                this.setError(this.getMessage("field-minlength-error", args));
                return true;
            }
            if (this.getMaxLength() > 0 && length > this.getMaxLength()) {
                Object[] args = new Object[]{this.getLabel(), new Integer(this.getMaxLength())};
                this.setError(this.getMessage("field-maxlength-error", args));
                return true;
            }
            return this.invokeListener();
        }
        if (this.isRequired()) {
            this.setError(this.getMessage("field-required-error", this.getLabel()));
        }
        return true;
    }

    public String toString() {
        HtmlStringBuffer buffer = new HtmlStringBuffer(96);
        buffer.elementStart("textarea");
        buffer.appendAttribute("name", this.getName());
        buffer.appendAttribute("id", this.getId());
        buffer.appendAttribute("rows", this.getRows());
        buffer.appendAttribute("cols", this.getCols());
        buffer.appendAttribute("title", this.getTitle());
        if (this.hasAttributes()) {
            buffer.appendAttributes(this.getAttributes());
        }
        if (this.isDisabled()) {
            buffer.appendAttributeDisabled();
        }
        if (this.isReadonly()) {
            buffer.appendAttributeReadonly();
        }
        if (!this.isValid()) {
            buffer.appendAttribute("class", "error");
        } else if (this.isDisabled()) {
            buffer.appendAttribute("class", "disabled");
        }
        buffer.closeTag();
        buffer.appendEscaped(this.getValue());
        buffer.elementEnd("textarea");
        return buffer.toString();
    }
}

