/*
 * Decompiled with CFR 0.152.
 */
package net.sf.click.control;

import net.sf.click.control.Button;
import net.sf.click.util.ClickUtils;
import org.apache.commons.lang.StringUtils;

public class Submit
extends Button {
    private static final long serialVersionUID = 866770311383007541L;
    protected boolean clicked;

    public Submit(String value) {
        super(value);
        if (value.toLowerCase().indexOf("&nbsp;") != -1) {
            String msg = "Cannot correctly process value containing: &nbsp;";
            throw new IllegalArgumentException(msg);
        }
    }

    public Submit(String value, String title) {
        this(value);
        this.setTitle(title);
    }

    public Submit(String value, Object listener, String method) {
        super(value);
        if (listener == null) {
            throw new IllegalArgumentException("Null listener parameter");
        }
        if (StringUtils.isBlank((String)method)) {
            throw new IllegalArgumentException("Blank listener method");
        }
        this.setListener(listener, method);
    }

    public Submit() {
    }

    public boolean isClicked() {
        return this.clicked;
    }

    public String getType() {
        return "submit";
    }

    public boolean onProcess() {
        String value = this.getContext().getRequestParameter(this.getName());
        if (value != null) {
            this.clicked = this.getName().equals(ClickUtils.toName(value));
            if (this.clicked) {
                return this.invokeListener();
            }
        }
        return true;
    }
}

