/*
 * Decompiled with CFR 0.152.
 */
package net.sf.click.control;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sf.click.control.Field;
import net.sf.click.control.Option;
import net.sf.click.control.OptionGroup;
import net.sf.click.util.HtmlStringBuffer;

public class Select
extends Field {
    private static final long serialVersionUID = -1192953011321870296L;
    protected boolean multiple;
    protected List optionList;
    protected int size = 1;
    protected List multipleValues;

    public Select(String label) {
        super(label);
    }

    public Select(String name, String label) {
        super(name, label);
    }

    public Select(String label, boolean required) {
        super(label);
    }

    public Select() {
    }

    public void add(Option option) {
        if (option == null) {
            throw new IllegalArgumentException("option parameter cannot be null");
        }
        this.getOptionList().add(option);
        if (this.getOptionList().size() == 1) {
            this.setInitialValue();
        }
    }

    public void add(OptionGroup optionGroup) {
        if (optionGroup == null) {
            throw new IllegalArgumentException("optionGroup parameter cannot be null");
        }
        this.getOptionList().add(optionGroup);
    }

    public void add(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value parameter cannot be null");
        }
        this.getOptionList().add(new Option(value));
        if (this.getOptionList().size() == 1) {
            this.setInitialValue();
        }
    }

    public void addAll(Collection options) {
        if (options == null) {
            throw new IllegalArgumentException("options parameter cannot be null");
        }
        this.getOptionList().addAll(options);
        this.setInitialValue();
    }

    public void addAll(List options) {
        if (options == null) {
            throw new IllegalArgumentException("options parameter cannot be null");
        }
        int size = options.size();
        for (int i = 0; i < size; ++i) {
            this.getOptionList().add(options.get(i));
        }
        this.setInitialValue();
    }

    public void addAll(String[] options) {
        if (options == null) {
            throw new IllegalArgumentException("options parameter cannot be null");
        }
        for (int i = 0; i < options.length; ++i) {
            String value = options[i];
            this.getOptionList().add(new Option(value, value));
        }
        this.setInitialValue();
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int rows) {
        this.size = rows;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public void setMultiple(boolean value) {
        this.multiple = value;
    }

    public List getMultipleValues() {
        if (this.multipleValues != null) {
            return this.multipleValues;
        }
        return Collections.EMPTY_LIST;
    }

    public List getOptionList() {
        if (this.optionList == null) {
            this.optionList = new ArrayList();
        }
        return this.optionList;
    }

    public void setOptionList(List options) {
        this.optionList = options;
    }

    public boolean onProcess() {
        if (this.getOptionList().isEmpty()) {
            return true;
        }
        if (!this.isMultiple()) {
            this.value = this.getContext().getRequestParameter(this.getName());
            if (this.validate() && this.value != null) {
                Option firstOption = (Option)this.getOptionList().get(0);
                if (this.isRequired() && firstOption.getValue().equals(this.value)) {
                    this.setError(this.getMessage("select-error", this.getLabel()));
                    return true;
                }
                return this.invokeListener();
            }
            return true;
        }
        this.multipleValues = new ArrayList();
        String[] values = this.getContext().getRequest().getParameterValues(this.getName());
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                this.multipleValues.add(values[i]);
            }
        }
        if (!this.validate()) {
            return true;
        }
        if (this.isRequired()) {
            if (this.multipleValues.isEmpty()) {
                this.setError(this.getMessage("select-error", this.getLabel()));
                return true;
            }
            return this.invokeListener();
        }
        if (this.multipleValues.isEmpty()) {
            return true;
        }
        return this.invokeListener();
    }

    public String toString() {
        int bufferSize = 50;
        if (!this.getOptionList().isEmpty()) {
            bufferSize += this.optionList.size() * 48;
        }
        HtmlStringBuffer buffer = new HtmlStringBuffer(bufferSize);
        buffer.elementStart("select");
        buffer.appendAttribute("name", this.getName());
        buffer.appendAttribute("id", this.getId());
        buffer.appendAttribute("size", this.getSize());
        buffer.appendAttribute("title", this.getTitle());
        if (this.isMultiple()) {
            buffer.appendAttribute("multiple", "multiple");
        }
        if (this.hasAttributes()) {
            buffer.appendAttributes(this.getAttributes());
        }
        if (this.isDisabled()) {
            buffer.appendAttributeDisabled();
        }
        if (this.isReadonly()) {
            buffer.appendAttributeReadonly();
        }
        if (!this.isValid()) {
            buffer.appendAttribute("class", "error");
        }
        buffer.closeTag();
        if (!this.getOptionList().isEmpty()) {
            int size = this.getOptionList().size();
            for (int i = 0; i < size; ++i) {
                Object object = this.getOptionList().get(i);
                if (object instanceof Option) {
                    Option option = (Option)object;
                    buffer.append(option.renderHTML(this));
                    continue;
                }
                if (object instanceof OptionGroup) {
                    OptionGroup optionGroup = (OptionGroup)object;
                    buffer.append(optionGroup.renderHTML(this));
                    continue;
                }
                String msg = "Select option class not instance of Option or OptionGroup: " + object.getClass().getName();
                throw new IllegalArgumentException(msg);
            }
        }
        buffer.elementEnd("select");
        return buffer.toString();
    }

    protected void setInitialValue() {
        if (!this.getOptionList().isEmpty()) {
            Object object = this.getOptionList().get(0);
            if (object instanceof String) {
                this.setValue(object.toString());
            } else if (object instanceof Option) {
                Option option = (Option)object;
                this.setValue(option.getValue());
            }
        }
    }
}

