/*
 * Decompiled with CFR 0.152.
 */
package net.sf.click.control;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.click.Context;
import net.sf.click.Control;
import net.sf.click.control.Field;
import net.sf.click.control.Form;
import net.sf.click.control.Radio;
import net.sf.click.util.HtmlStringBuffer;

public class RadioGroup
extends Field {
    private static final long serialVersionUID = 2978451472698468194L;
    protected List radioList;
    protected boolean isVerticalLayout = true;

    public RadioGroup(String label) {
        super(label);
    }

    public RadioGroup(String name, String label) {
        super(name, label);
    }

    public RadioGroup() {
    }

    public void add(Radio radio) {
        if (radio == null) {
            throw new IllegalArgumentException("Null radio parameter");
        }
        radio.setName(this.getName());
        this.getRadioList().add(radio);
        if (this.getContext() != null) {
            radio.setContext(this.getContext());
        }
    }

    public void setContext(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Null context parameter");
        }
        this.context = context;
        if (this.hasRadios()) {
            Iterator i = this.getRadioList().iterator();
            while (i.hasNext()) {
                Object object = i.next();
                if (!(object instanceof Control)) continue;
                ((Control)object).setContext(context);
            }
        }
    }

    public void setForm(Form form) {
        super.setForm(form);
        if (this.hasRadios()) {
            int size = this.getRadioList().size();
            for (int i = 0; i < size; ++i) {
                Radio radio = (Radio)this.getRadioList().get(i);
                radio.setForm(this.getForm());
            }
        }
    }

    public boolean isVerticalLayout() {
        return this.isVerticalLayout;
    }

    public void setVerticalLayout(boolean vertical) {
        this.isVerticalLayout = vertical;
    }

    public List getRadioList() {
        if (this.radioList == null) {
            this.radioList = new ArrayList();
        }
        return this.radioList;
    }

    public boolean hasRadios() {
        return this.radioList != null && !this.radioList.isEmpty();
    }

    public boolean onProcess() {
        this.value = this.getRequestValue();
        boolean continueProcessing = true;
        int size = this.getRadioList().size();
        for (int i = 0; i < size; ++i) {
            Radio radio = (Radio)this.getRadioList().get(i);
            continueProcessing = radio.onProcess();
            if (continueProcessing || !this.validate()) continue;
            return false;
        }
        if (!this.validate()) {
            return true;
        }
        if (this.value.length() > 0) {
            return this.invokeListener();
        }
        return true;
    }

    public String toString() {
        int size = this.getRadioList().size();
        HtmlStringBuffer buffer = new HtmlStringBuffer(size * 30);
        String value = this.getValue();
        for (int i = 0; i < size; ++i) {
            Radio radio = (Radio)this.getRadioList().get(i);
            if (value != null && value.length() > 0) {
                if (radio.getValue().equals(value)) {
                    radio.setChecked(true);
                } else {
                    radio.setChecked(false);
                }
            }
            buffer.append(radio.toString());
            if (!this.isVerticalLayout() || i >= size - 1) continue;
            buffer.append("<br/>");
        }
        return buffer.toString();
    }
}

