/*
 * Decompiled with CFR 0.152.
 */
package net.sf.click.control;

import net.sf.click.control.Field;
import net.sf.click.util.HtmlStringBuffer;

public class Radio
extends Field {
    private static final long serialVersionUID = 6352053148711861658L;
    protected boolean checked;

    public Radio() {
    }

    public Radio(String value) {
        this.setValue(value);
    }

    public Radio(String value, String label) {
        this.setValue(value);
        this.setLabel(label);
    }

    public Radio(String value, String label, String name) {
        this.setValue(value);
        this.setLabel(label);
        this.setName(name);
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean value) {
        this.checked = value;
    }

    public String getType() {
        return "radio";
    }

    public boolean onProcess() {
        String value = this.getRequestValue();
        this.checked = this.getValue().equals(value);
        if (!this.validate()) {
            return true;
        }
        if (this.checked) {
            return this.invokeListener();
        }
        return true;
    }

    public String toString() {
        HtmlStringBuffer buffer = new HtmlStringBuffer();
        buffer.elementStart("input");
        buffer.appendAttribute("type", this.getType());
        buffer.appendAttribute("name", this.getName());
        buffer.appendAttribute("value", this.getValue());
        buffer.appendAttribute("title", this.getTitle());
        if (this.isChecked()) {
            buffer.appendAttribute("checked", "checked");
        }
        if (this.hasAttributes()) {
            buffer.appendAttributes(this.getAttributes());
        }
        if (this.isDisabled()) {
            buffer.appendAttributeDisabled();
        }
        if (this.isReadonly()) {
            buffer.appendAttributeReadonly();
        }
        if (!this.isValid()) {
            buffer.appendAttribute("class", "error");
        }
        buffer.closeTag();
        if (this.getLabel() != null) {
            buffer.appendEscaped(this.getLabel());
        } else {
            buffer.appendEscaped(this.getValue());
        }
        buffer.elementEnd("input");
        return buffer.toString();
    }
}

