/*
 * Decompiled with CFR 0.152.
 */
package net.sf.click.control;

import java.util.ArrayList;
import java.util.List;
import net.sf.click.control.Option;
import net.sf.click.control.Select;
import net.sf.click.util.HtmlStringBuffer;

public class OptionGroup {
    protected List children = new ArrayList();
    protected final String label;

    public OptionGroup(String label) {
        this.label = label;
    }

    public void add(Object object) {
        this.getChildren().add(object);
    }

    public List getChildren() {
        return this.children;
    }

    public String getLabel() {
        return this.label;
    }

    public String renderHTML(Select select) {
        HtmlStringBuffer buffer = new HtmlStringBuffer();
        buffer.elementStart("optgroup");
        buffer.appendAttribute("label", this.getLabel());
        buffer.closeTag();
        List list = this.getChildren();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Object object = list.get(i);
            if (object instanceof Option) {
                Option option = (Option)object;
                buffer.append(option.renderHTML(select));
                continue;
            }
            if (object instanceof OptionGroup) {
                OptionGroup optionGroup = (OptionGroup)object;
                buffer.append(optionGroup.renderHTML(select));
                continue;
            }
            String msg = "Select option class not instance of Option or OptionGroup: " + object.getClass().getName();
            throw new IllegalArgumentException(msg);
        }
        buffer.elementEnd("optgroup");
        return buffer.toString();
    }
}

