/*
 * Decompiled with CFR 0.152.
 */
package net.sf.click.control;

import java.util.List;
import net.sf.click.control.Select;
import net.sf.click.util.HtmlStringBuffer;

public class Option {
    protected final String label;
    protected final String value;

    public Option(Object value, String label) {
        this.value = value.toString();
        this.label = label;
    }

    public Option(String value) {
        this(value, value);
    }

    public String getLabel() {
        return this.label;
    }

    public String getValue() {
        return this.value;
    }

    public String renderHTML(Select select) {
        HtmlStringBuffer buffer = new HtmlStringBuffer(48);
        buffer.elementStart("option");
        if (select.isMultiple()) {
            if (!select.getMultipleValues().isEmpty()) {
                List values = select.getMultipleValues();
                int size = values.size();
                for (int i = 0; i < size; ++i) {
                    String value = values.get(i).toString();
                    if (!this.getValue().equals(value)) continue;
                    buffer.appendAttribute("selected", "selected");
                    break;
                }
            }
        } else if (this.getValue().equals(select.getValue())) {
            buffer.appendAttribute("selected", "selected");
        }
        buffer.appendAttribute("value", this.getValue());
        buffer.closeTag();
        buffer.appendEscaped(this.getLabel());
        buffer.elementEnd("option");
        return buffer.toString();
    }
}

