/*
 * Decompiled with CFR 0.152.
 */
package net.sf.click.control;

import net.sf.click.control.TextField;

public class IntegerField
extends TextField {
    private static final long serialVersionUID = -2239992411551673682L;
    protected int maxvalue = Integer.MAX_VALUE;
    protected int minvalue = Integer.MIN_VALUE;

    public IntegerField(String label) {
        super(label);
        this.setAttribute("onKeyPress", "javascript:return integerFilter(event);");
    }

    public IntegerField(String name, String label) {
        super(name, label);
        this.setAttribute("onKeyPress", "javascript:return integerFilter(event);");
    }

    public IntegerField(String label, boolean required) {
        this(label);
        this.setRequired(required);
    }

    public IntegerField() {
        this.setAttribute("onKeyPress", "javascript:return integerFilter(event);");
    }

    public Integer getInteger() {
        String value = this.getValue();
        if (value != null && value.length() > 0) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        return null;
    }

    public Long getLong() {
        String value = this.getValue();
        if (value != null && value.length() > 0) {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        return null;
    }

    public int getMaxValue() {
        return this.maxvalue;
    }

    public void setMaxValue(int value) {
        this.maxvalue = value;
    }

    public int getMinValue() {
        return this.minvalue;
    }

    public void setMinValue(int value) {
        this.minvalue = value;
    }

    public boolean onProcess() {
        this.value = this.getRequestValue();
        if (!this.validate()) {
            return true;
        }
        int length = this.value.length();
        if (length > 0) {
            try {
                int intValue = Integer.parseInt(this.value);
                if (intValue > this.maxvalue) {
                    Object[] args = new Object[]{this.getLabel(), new Integer(this.maxvalue)};
                    this.setError(this.getMessage("number-maxvalue-error", args));
                    return true;
                }
                if (intValue < this.minvalue) {
                    Object[] args = new Object[]{this.getLabel(), new Integer(this.minvalue)};
                    this.setError(this.getMessage("number-minvalue-error", args));
                    return true;
                }
                return this.invokeListener();
            }
            catch (NumberFormatException nfe) {
                this.setError(this.getMessage("integer-format-error", this.getLabel()));
            }
        } else if (this.isRequired()) {
            this.setError(this.getMessage("field-required-error", this.getLabel()));
        }
        return true;
    }
}

