/*
 * Decompiled with CFR 0.152.
 */
package net.sf.click.control;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import net.sf.click.control.Field;
import net.sf.click.util.ClickUtils;
import net.sf.click.util.HtmlStringBuffer;

public class HiddenField
extends Field {
    private static final long serialVersionUID = 4705251470274077158L;
    protected Object valueObject;
    protected Class valueClass;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$io$Serializable;

    public HiddenField(String name, Class valueClass) {
        this.name = name;
        this.valueClass = valueClass;
    }

    public HiddenField() {
    }

    public boolean isHidden() {
        return true;
    }

    public String getType() {
        return "hidden";
    }

    public String getValue() {
        return this.valueObject != null ? this.valueObject.toString() : "";
    }

    public void setValue(Object value) {
        if (value != null && value.getClass() != this.valueClass) {
            String msg = "The value.getClass() must be the same as the HiddenField valueClass: " + (this.valueClass != null ? this.valueClass.getName() : "null");
            throw new IllegalArgumentException(msg);
        }
        this.valueObject = value;
    }

    public Class getValueClass() {
        return this.valueClass;
    }

    public void setValueClass(Class valueClass) {
        this.valueClass = valueClass;
    }

    public Object getValueObject() {
        return this.valueObject;
    }

    public boolean onProcess() {
        String aValue = this.getRequestValue();
        Class valueClass = this.getValueClass();
        if (valueClass == (class$java$lang$String == null ? (class$java$lang$String = HiddenField.class$("java.lang.String")) : class$java$lang$String)) {
            this.setValue(aValue);
        } else if (aValue != null && aValue.length() > 0) {
            if (valueClass == (class$java$lang$Integer == null ? (class$java$lang$Integer = HiddenField.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                this.setValue(Integer.valueOf(aValue));
            } else if (valueClass == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = HiddenField.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                this.setValue(Boolean.valueOf(aValue));
            } else if (valueClass == (class$java$lang$Double == null ? (class$java$lang$Double = HiddenField.class$("java.lang.Double")) : class$java$lang$Double)) {
                this.setValue(Double.valueOf(aValue));
            } else if (valueClass == (class$java$lang$Float == null ? (class$java$lang$Float = HiddenField.class$("java.lang.Float")) : class$java$lang$Float)) {
                this.setValue(Float.valueOf(aValue));
            } else if (valueClass == (class$java$lang$Long == null ? (class$java$lang$Long = HiddenField.class$("java.lang.Long")) : class$java$lang$Long)) {
                this.setValue(Long.valueOf(aValue));
            } else if (valueClass == (class$java$lang$Short == null ? (class$java$lang$Short = HiddenField.class$("java.lang.Short")) : class$java$lang$Short)) {
                this.setValue(Short.valueOf(aValue));
            } else if ((class$java$util$Date == null ? (class$java$util$Date = HiddenField.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(valueClass)) {
                long time = Long.parseLong(aValue);
                this.setValue(new Date(time));
            } else if ((class$java$io$Serializable == null ? (class$java$io$Serializable = HiddenField.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(valueClass)) {
                try {
                    this.setValue(ClickUtils.decode(aValue));
                }
                catch (ClassNotFoundException cnfe) {
                    String msg = "could not decode value for hidden field: " + aValue;
                    throw new RuntimeException(msg, cnfe);
                }
                catch (IOException ioe) {
                    String msg = "could not decode value for hidden field: " + aValue;
                    throw new RuntimeException(msg, ioe);
                }
            } else {
                this.setValue(aValue);
            }
        } else {
            this.setValue(null);
        }
        return this.invokeListener();
    }

    public String toString() {
        HtmlStringBuffer buffer = new HtmlStringBuffer();
        buffer.elementStart("input");
        buffer.appendAttribute("type", this.getType());
        buffer.appendAttribute("name", this.getName());
        buffer.appendAttribute("id", this.getId());
        String valueStr = null;
        if (this.valueClass == (class$java$lang$String == null ? (class$java$lang$String = HiddenField.class$("java.lang.String")) : class$java$lang$String) || this.valueClass == (class$java$lang$Integer == null ? (class$java$lang$Integer = HiddenField.class$("java.lang.Integer")) : class$java$lang$Integer) || this.valueClass == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = HiddenField.class$("java.lang.Boolean")) : class$java$lang$Boolean) || this.valueClass == (class$java$lang$Double == null ? (class$java$lang$Double = HiddenField.class$("java.lang.Double")) : class$java$lang$Double) || this.valueClass == (class$java$lang$Float == null ? (class$java$lang$Float = HiddenField.class$("java.lang.Float")) : class$java$lang$Float) || this.valueClass == (class$java$lang$Long == null ? (class$java$lang$Long = HiddenField.class$("java.lang.Long")) : class$java$lang$Long) || this.valueClass == (class$java$lang$Short == null ? (class$java$lang$Short = HiddenField.class$("java.lang.Short")) : class$java$lang$Short)) {
            valueStr = String.valueOf(this.getValue());
        } else if (this.getValueObject() instanceof Date) {
            valueStr = String.valueOf(((Date)this.getValueObject()).getTime());
        } else if (this.getValueObject() instanceof Serializable) {
            try {
                valueStr = ClickUtils.encode(this.getValueObject());
            }
            catch (IOException ioe) {
                String msg = "could not encode value for hidden field: " + this.getValueObject();
                throw new RuntimeException(msg, ioe);
            }
        } else {
            valueStr = this.getValue();
        }
        buffer.appendAttribute("value", valueStr);
        buffer.elementEnd();
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

