/*
 * Decompiled with CFR 0.152.
 */
package net.sf.click.control;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.click.Context;
import net.sf.click.Control;
import net.sf.click.control.Button;
import net.sf.click.control.Field;
import net.sf.click.control.FieldSet;
import net.sf.click.control.FileField;
import net.sf.click.control.HiddenField;
import net.sf.click.control.Label;
import net.sf.click.util.ClickUtils;
import net.sf.click.util.HtmlStringBuffer;
import org.apache.commons.fileupload.DefaultFileItemFactory;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.lang.StringUtils;

public class Form
implements Control {
    private static final long serialVersionUID = -8288409197675214969L;
    public static final String ALIGN_LEFT = "left";
    public static final String ALIGN_CENTER = "center";
    public static final String ALIGN_RIGHT = "right";
    public static final String FORM_NAME = "form_name";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String POSITION_TOP = "top";
    public static final String POSITION_MIDDLE = "middle";
    public static final String POSITION_BOTTOM = "bottom";
    public static final String POSITION_LEFT = "left";
    protected static String errorsHeader = "";
    protected static String errorsFooter = "";
    protected static String errorsPrefix = "";
    protected static String errorsSuffix = "";
    protected static String labelRequiredPrefix = "";
    protected static String labelRequiredSuffix = "";
    protected static final String HTML_IMPORTS = "<link rel=\"stylesheet\" type=\"text/css\" href=\"$/click/control.css\" title=\"style\">\n<script type=\"text/javascript\" src=\"$/click/control.js\"></script>\n<script type=\"text/javascript\" src=\"$/click/calendar-en.js\"></script>\n";
    protected Map attributes;
    protected String buttonAlign = "left";
    protected final List buttonList = new ArrayList(5);
    protected int columns = 1;
    protected Context context;
    protected boolean disabled;
    protected String enctype;
    protected String error;
    protected String errorsAlign = "left";
    protected String errorsPosition = "middle";
    protected final List fieldList = new ArrayList();
    protected final Map fields = new HashMap();
    protected String labelAlign = "left";
    protected String labelsPosition = "left";
    protected Object listener;
    protected String listenerMethod;
    protected String method = "POST";
    protected String name;
    protected boolean readonly;
    protected boolean validate = true;
    static /* synthetic */ Class class$java$lang$String;

    public Form(String name) {
        this.setName(name);
    }

    public Form() {
    }

    public void add(Field field) {
        if (field == null) {
            throw new IllegalArgumentException("field parameter cannot be null");
        }
        if (StringUtils.isBlank((String)field.getName())) {
            throw new IllegalArgumentException("Field name not defined");
        }
        if (this.getFields().containsKey(field.getName()) && !(field instanceof Label)) {
            throw new IllegalArgumentException("Form already contains field named: " + field.getName());
        }
        if (field instanceof Button) {
            this.getButtonList().add(field);
        } else {
            this.getFieldList().add(field);
        }
        this.getFields().put(field.getName(), field);
        field.setForm(this);
        if (this.getContext() != null) {
            field.setContext(this.getContext());
        }
    }

    public void remove(Field field) {
        if (field != null && this.getFields().containsKey(field.getName())) {
            field.setForm(null);
            this.getFields().remove(field.getName());
            if (field instanceof Button) {
                this.getButtonList().remove(field);
            } else {
                this.getFieldList().remove(field);
            }
        }
    }

    public void removeField(String name) {
        this.remove(this.getField(name));
    }

    public void removeFields(List fieldNames) {
        if (fieldNames != null) {
            for (int i = 0; i < fieldNames.size(); ++i) {
                this.removeField(fieldNames.get(i).toString());
            }
        }
    }

    public String getAttribute(String name) {
        if (this.attributes != null) {
            return (String)this.attributes.get(name);
        }
        return null;
    }

    public void setAttribute(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Null name parameter");
        }
        if (this.attributes == null) {
            this.attributes = new HashMap(5);
        }
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    public Map getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap(5);
        }
        return this.attributes;
    }

    public boolean hasAttributes() {
        return this.attributes != null && !this.attributes.isEmpty();
    }

    public String getButtonAlign() {
        return this.buttonAlign;
    }

    public void setButtonAlign(String align) {
        this.buttonAlign = align;
    }

    public List getButtonList() {
        return this.buttonList;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Null context parameter");
        }
        this.context = context;
        if (!this.getFields().isEmpty()) {
            Iterator i = this.getFields().values().iterator();
            while (i.hasNext()) {
                Object object = i.next();
                if (!(object instanceof Control)) continue;
                ((Control)object).setContext(context);
            }
        }
    }

    public String getEnctype() {
        if (this.enctype == null) {
            int size = this.fieldList.size();
            for (int i = 0; i < size; ++i) {
                Field field = (Field)this.fieldList.get(i);
                if (field.isHidden() || !(field instanceof FileField)) continue;
                this.enctype = MULTIPART_FORM_DATA;
                break;
            }
        }
        return this.enctype;
    }

    public void setEnctype(String enctype) {
        this.enctype = enctype;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getErrorsAlign() {
        return this.errorsAlign;
    }

    public void setErrorsAlign(String align) {
        this.errorsAlign = align;
    }

    public List getErrorFields() {
        ArrayList<Field> list = new ArrayList<Field>();
        int size = this.fieldList.size();
        for (int i = 0; i < size; ++i) {
            Field field = (Field)this.fieldList.get(i);
            if (field instanceof FieldSet) {
                FieldSet fieldSet = (FieldSet)field;
                for (int j = 0; j < fieldSet.getFieldList().size(); ++j) {
                    Field fieldSetField = (Field)fieldSet.getFieldList().get(j);
                    if (fieldSetField.isValid() || fieldSetField.isHidden() || fieldSetField.isDisabled()) continue;
                    list.add(fieldSetField);
                }
                continue;
            }
            if (field.isValid() || field.isHidden() || field.isDisabled()) continue;
            list.add(field);
        }
        return list;
    }

    public String getErrorsPosition() {
        return this.errorsPosition;
    }

    public void setErrorsPosition(String position) {
        if (!(POSITION_TOP.equals(position) || POSITION_MIDDLE.equals(position) || POSITION_BOTTOM.equals(position))) {
            throw new IllegalArgumentException("Invalid position: " + position);
        }
        this.errorsPosition = position;
    }

    public Field getField(String name) {
        return (Field)this.fields.get(name);
    }

    public List getFieldList() {
        return this.fieldList;
    }

    public Map getFields() {
        return this.fields;
    }

    public String getFieldValue(String name) {
        Field field = this.getField(name);
        if (field != null) {
            return field.getValue();
        }
        for (int i = 0; i < this.getFieldList().size(); ++i) {
            FieldSet fieldSet;
            field = (Field)this.getFieldList().get(i);
            if (!(field instanceof FieldSet) || (fieldSet = (FieldSet)field).getField(name) == null) continue;
            return fieldSet.getField(name).getValue();
        }
        return null;
    }

    public String getHtmlImports() {
        String path = this.context.getRequest().getContextPath();
        return StringUtils.replace((String)HTML_IMPORTS, (String)"$", (String)path);
    }

    public String getId() {
        if (this.hasAttributes() && this.getAttributes().containsKey("id")) {
            return this.getAttribute("id");
        }
        return this.getName();
    }

    public String getLabelAlign() {
        return this.labelAlign;
    }

    public void setLabelAlign(String align) {
        this.labelAlign = align;
    }

    public String getLabelsPosition() {
        return this.labelsPosition;
    }

    public void setLabelsPosition(String position) {
        if (!"left".equals(position) && !POSITION_TOP.equals(position)) {
            throw new IllegalArgumentException("Invalid position: " + position);
        }
        this.labelsPosition = position;
    }

    public void setListener(Object target, String methodName) {
        this.listener = target;
        this.listenerMethod = methodName;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String value) {
        this.method = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name parameter");
        }
        this.name = name;
        HiddenField nameField = new HiddenField(FORM_NAME, class$java$lang$String == null ? (class$java$lang$String = Form.class$("java.lang.String")) : class$java$lang$String);
        nameField.setValue(name);
        this.add(nameField);
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean isValid() {
        if (this.getError() != null) {
            return false;
        }
        int size = this.fieldList.size();
        for (int i = 0; i < size; ++i) {
            Field field = (Field)this.fieldList.get(i);
            if (field.isValid()) continue;
            return false;
        }
        return true;
    }

    public boolean getValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public void copyFrom(Object object) {
        ClickUtils.copyObjectToForm(object, this, false);
    }

    public void copyFrom(Object object, boolean debug) {
        ClickUtils.copyObjectToForm(object, this, debug);
    }

    public void copyTo(Object object) {
        ClickUtils.copyFormToObject(this, object, false);
    }

    public void copyTo(Object object, boolean debug) {
        ClickUtils.copyFormToObject(this, object, debug);
    }

    public boolean onProcess() {
        HttpServletRequest request = this.getContext().getRequest();
        if (request.getMethod().equalsIgnoreCase(this.getMethod())) {
            int i;
            String formName;
            if (this.getContext().isMultipartRequest() && this.getContext().getMultiPartFormData() == Collections.EMPTY_MAP) {
                FileField fileField = null;
                int size = this.fieldList.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    Field field = (Field)this.fieldList.get(i2);
                    if (field.isHidden() || !(field instanceof FileField)) continue;
                    fileField = (FileField)field;
                    break;
                }
                FileUploadBase fileUpload = null;
                if (fileField != null) {
                    fileUpload = fileField.getFileUpload();
                    if (fileUpload.getFileItemFactory() == null) {
                        DefaultFileItemFactory fif = new DefaultFileItemFactory();
                        fileUpload.setFileItemFactory((FileItemFactory)fif);
                    }
                } else {
                    String msg = "No FileField defined for POST Content-type 'multipart' request";
                    throw new RuntimeException(msg);
                }
                try {
                    List itemsList = fileUpload.parseRequest(request);
                    HashMap<String, FileItem> itemsMap = new HashMap<String, FileItem>(itemsList.size());
                    for (int i3 = 0; i3 < itemsList.size(); ++i3) {
                        FileItem fileItem = (FileItem)itemsList.get(i3);
                        itemsMap.put(fileItem.getFieldName(), fileItem);
                    }
                    this.getContext().setMultiPartFormData(itemsMap);
                }
                catch (FileUploadException fue) {
                    throw new RuntimeException(fue);
                }
            }
            if ((formName = this.getContext().getRequestParameter(FORM_NAME)) == null || !formName.equals(this.getName())) {
                return true;
            }
            boolean continueProcessing = true;
            int size = this.fieldList.size();
            for (i = 0; i < size; ++i) {
                Field field = (Field)this.fieldList.get(i);
                continueProcessing = field.onProcess();
                if (continueProcessing) continue;
                return false;
            }
            size = this.buttonList.size();
            for (i = 0; i < size; ++i) {
                Button button = (Button)this.buttonList.get(i);
                continueProcessing = button.onProcess();
                if (continueProcessing) continue;
                return false;
            }
            if (this.listener != null && this.listenerMethod != null) {
                return ClickUtils.invokeListener(this.listener, this.listenerMethod);
            }
        }
        return true;
    }

    public String toString() {
        Field field;
        int i;
        int size;
        boolean process = this.context.getRequest().getMethod().equalsIgnoreCase(this.getMethod());
        int bufferSize = 400 + this.fieldList.size() * 350 + this.buttonList.size() * 50;
        HtmlStringBuffer buffer = new HtmlStringBuffer(bufferSize);
        HttpServletRequest request = this.getContext().getRequest();
        HttpServletResponse response = this.getContext().getResponse();
        String actionURL = response.encodeURL(request.getRequestURI());
        buffer.elementStart("form");
        buffer.appendAttribute("method", this.getMethod());
        buffer.appendAttribute("name", this.getName());
        buffer.appendAttribute("id", this.getId());
        buffer.appendAttribute("action", actionURL);
        buffer.appendAttribute("enctype", this.getEnctype());
        if (this.hasAttributes()) {
            buffer.appendAttributes(this.getAttributes());
        }
        buffer.closeTag();
        buffer.append("\n");
        int hiddenCount = 0;
        Field fieldWithError = null;
        buffer.append("<table class=\"form\" id=\"");
        buffer.append(this.getId());
        buffer.append("-form\">\n");
        if (POSITION_TOP.equals(this.getErrorsPosition())) {
            fieldWithError = this.renderErrors(buffer, process);
            hiddenCount = this.renderFields(buffer);
            this.renderButtons(buffer);
        } else if (POSITION_MIDDLE.equals(this.getErrorsPosition())) {
            hiddenCount = this.renderFields(buffer);
            fieldWithError = this.renderErrors(buffer, process);
            this.renderButtons(buffer);
        } else if (POSITION_BOTTOM.equals(this.getErrorsPosition())) {
            hiddenCount = this.renderFields(buffer);
            this.renderButtons(buffer);
            fieldWithError = this.renderErrors(buffer, process);
        } else {
            String msg = "Invalid errorsPositon:" + this.getErrorsPosition();
            throw new IllegalArgumentException(msg);
        }
        buffer.append("</table>\n");
        if (hiddenCount > 0) {
            size = this.fieldList.size();
            for (i = 0; i < size; ++i) {
                field = (Field)this.fieldList.get(i);
                if (!field.isHidden()) continue;
                buffer.append(field);
                buffer.append("\n");
                if (--hiddenCount == 0) break;
            }
        }
        buffer.elementEnd("form");
        buffer.append("\n");
        if (fieldWithError != null) {
            buffer.append("<script type=\"text/javascript\"><!--\n");
            buffer.append("document.forms['");
            buffer.append(this.getName());
            buffer.append("'].elements['");
            buffer.append(fieldWithError.getName());
            buffer.append("'].focus();\n");
            buffer.append("//--></script>\n");
        } else {
            size = this.fieldList.size();
            block1: for (i = 0; i < size; ++i) {
                field = (Field)this.fieldList.get(i);
                if (field instanceof FieldSet) {
                    FieldSet fieldSet = (FieldSet)field;
                    for (int j = 0; j < fieldSet.getFieldList().size(); ++j) {
                        Field fieldSetField = (Field)fieldSet.getFieldList().get(j);
                        if (!fieldSetField.getFocus() || fieldSetField.isHidden() || fieldSetField.isDisabled()) continue;
                        buffer.append("<script type=\"text/javascript\"><!--\n");
                        buffer.append("document.forms['");
                        buffer.append(this.getName());
                        buffer.append("'].elements['");
                        buffer.append(fieldSetField.getName());
                        buffer.append("'].focus();\n");
                        buffer.append("//--></script>\n");
                        continue block1;
                    }
                    continue;
                }
                if (!field.getFocus() || field.isHidden() || field.isDisabled()) continue;
                buffer.append("<script type=\"text/javascript\"><!--\n");
                buffer.append("document.forms['");
                buffer.append(this.getName());
                buffer.append("'].elements['");
                buffer.append(field.getName());
                buffer.append("'].focus();\n");
                buffer.append("//--></script>\n");
                break;
            }
        }
        return buffer.toString();
    }

    protected int renderFields(HtmlStringBuffer buffer) {
        if (this.fieldList.size() == 1 && this.fields.containsKey(FORM_NAME)) {
            return 1;
        }
        int hiddenCount = 0;
        buffer.append("<tr><td>\n");
        buffer.append("<table class=\"fields\" id=\"");
        buffer.append(this.getId());
        buffer.append("-fields\">\n");
        int column = 1;
        int size = this.fieldList.size();
        for (int i = 0; i < size; ++i) {
            Field field = (Field)this.fieldList.get(i);
            if (!field.isHidden()) {
                if (column == 1) {
                    buffer.append("<tr class=\"fields\">\n");
                }
                if (field instanceof FieldSet) {
                    buffer.append("<td class=\"fields\" colspan=\"2\" align=\"");
                    buffer.append(this.getLabelAlign());
                    buffer.append("\">\n");
                    buffer.append(field);
                    buffer.append("</td>\n");
                } else if (field instanceof Label) {
                    buffer.append("<td class=\"fields\" colspan=\"2\" align=\"");
                    buffer.append(this.getLabelAlign());
                    buffer.append("\"");
                    if (field.hasAttributes()) {
                        buffer.appendAttributes(field.getAttributes());
                    }
                    buffer.append(">");
                    buffer.append(field);
                    buffer.append("</td>\n");
                } else {
                    if ("left".equals(this.getLabelsPosition())) {
                        buffer.append("<td class=\"fields\" align=\"");
                        buffer.append(this.getLabelAlign());
                        buffer.append("\">");
                    } else {
                        buffer.append("<td class=\"fields\" valign=\"top\">");
                    }
                    if (field.isRequired()) {
                        buffer.append(labelRequiredPrefix);
                    }
                    buffer.append("<label");
                    if (field.isDisabled()) {
                        buffer.append(" disabled=\"disabled\"");
                    }
                    if (field.getError() != null) {
                        buffer.append(" class=\"error\"");
                    }
                    buffer.append(">");
                    buffer.append(field.getLabel());
                    buffer.append("</label>");
                    if (field.isRequired()) {
                        buffer.append(labelRequiredSuffix);
                    }
                    if ("left".equals(this.getLabelsPosition())) {
                        buffer.append("</td>\n");
                        buffer.append("<td align=\"left\">");
                    } else {
                        buffer.append("<br>");
                    }
                    buffer.append(field);
                    buffer.append("</td>\n");
                }
                if (column == this.getColumns()) {
                    buffer.append("</tr>\n");
                    column = 1;
                    continue;
                }
                ++column;
                continue;
            }
            ++hiddenCount;
        }
        buffer.append("</table>\n");
        buffer.append("</td></tr>\n");
        return hiddenCount;
    }

    protected Field renderErrors(HtmlStringBuffer buffer, boolean processed) {
        Field fieldWithError = null;
        if (processed && !this.isValid()) {
            boolean useErrorsHeader;
            String headerTest = errorsHeader.toLowerCase() + errorsPrefix.toLowerCase();
            boolean bl = useErrorsHeader = (headerTest.indexOf("<ul") > -1 || headerTest.indexOf("<ol") > -1) && headerTest.indexOf("<li") > -1;
            if (useErrorsHeader) {
                buffer.append(errorsHeader);
                buffer.append("\n");
            } else {
                buffer.append("<tr><td align=\"");
                buffer.append(this.getErrorsAlign());
                buffer.append("\">\n");
                buffer.append("<table class=\"errors\" id=\"");
                buffer.append(this.getId());
                buffer.append("-errors\">\n");
            }
            if (this.getError() != null) {
                if (useErrorsHeader) {
                    buffer.append(errorsPrefix);
                } else {
                    buffer.append("<tr class=\"errors\">");
                    buffer.append("<td class=\"errors\" align=\"");
                    buffer.append(this.getErrorsAlign());
                    buffer.append("\">\n");
                }
                buffer.append("<span class=\"error\">");
                buffer.append(this.getError());
                buffer.append("</span>\n");
                if (useErrorsHeader) {
                    buffer.append(errorsSuffix);
                    buffer.append("\n");
                } else {
                    buffer.append("</td></tr>\n");
                }
            }
            List errorFieldList = this.getErrorFields();
            int size = errorFieldList.size();
            for (int i = 0; i < size; ++i) {
                Field field = (Field)errorFieldList.get(i);
                if (fieldWithError == null && !field.isDisabled()) {
                    fieldWithError = field;
                }
                if (useErrorsHeader) {
                    buffer.append(errorsPrefix);
                } else {
                    buffer.append("<tr class=\"errors\">");
                    buffer.append("<td class=\"errors\" align=\"");
                    buffer.append(this.getErrorsAlign());
                    buffer.append("\">");
                }
                buffer.append("<a class=\"error\"");
                buffer.append(" href=\"javascript:document.");
                buffer.append(this.getName());
                buffer.append(".");
                buffer.append(field.getName());
                buffer.append(".focus();\">");
                buffer.append(field.getError());
                buffer.append("</a>");
                if (useErrorsHeader) {
                    buffer.append(errorsSuffix);
                    buffer.append("\n");
                    continue;
                }
                buffer.append("</td></tr>\n");
            }
            if (useErrorsHeader) {
                buffer.append(errorsFooter);
                buffer.append("\n");
            } else {
                buffer.append("</table>\n");
                buffer.append("</td></tr>\n");
            }
        }
        return fieldWithError;
    }

    protected void renderButtons(HtmlStringBuffer buffer) {
        if (!this.buttonList.isEmpty()) {
            buffer.append("<tr><td align=\"");
            buffer.append(this.getButtonAlign());
            buffer.append("\">\n");
            buffer.append("<table class=\"buttons\" id=\"");
            buffer.append(this.getId());
            buffer.append("-buttons\">\n");
            buffer.append("<tr class=\"buttons\"><td class=\"buttons\">");
            int size = this.buttonList.size();
            for (int i = 0; i < size; ++i) {
                Button button = (Button)this.buttonList.get(i);
                buffer.append(button);
                if (i > size - 1) continue;
                buffer.append(" ");
            }
            buffer.append("</td></tr>\n");
            buffer.append("</table>\n");
            buffer.append("</td></tr>\n");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ResourceBundle bundle = ResourceBundle.getBundle("click-control");
        errorsHeader = bundle.getString("errors-header");
        errorsFooter = bundle.getString("errors-footer");
        errorsPrefix = bundle.getString("errors-prefix");
        errorsSuffix = bundle.getString("errors-suffix");
        labelRequiredPrefix = bundle.getString("label-required-prefix");
        labelRequiredSuffix = bundle.getString("label-required-suffix");
    }
}

