/*
 * Decompiled with CFR 0.152.
 */
package net.sf.click.control;

import net.sf.click.control.Field;
import net.sf.click.util.HtmlStringBuffer;
import org.apache.commons.fileupload.DefaultFileItemFactory;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadBase;

public class FileField
extends Field {
    private static final long serialVersionUID = 2557325521464484964L;
    protected int size = 20;
    protected FileItem fileItem;
    protected FileUploadBase fileUpload;

    public FileField(String label) {
        super(label);
    }

    public FileField(String name, String label) {
        super(name, label);
    }

    public FileField(String label, boolean required) {
        super(label);
        this.setRequired(required);
    }

    public FileField() {
    }

    public FileItem getFileItem() {
        return this.fileItem;
    }

    public FileUploadBase getFileUpload() {
        if (this.fileUpload == null) {
            this.fileUpload = new FileUpload();
            this.fileUpload.setFileItemFactory((FileItemFactory)new DefaultFileItemFactory());
        }
        return this.fileUpload;
    }

    public void setFileUpload(FileUploadBase fileUpload) {
        this.fileUpload = fileUpload;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getType() {
        return "file";
    }

    public boolean onProcess() {
        this.fileItem = (FileItem)this.getContext().getMultiPartFormData().get(this.getName());
        if (!this.validate()) {
            return true;
        }
        if (this.fileItem != null) {
            if (this.isRequired() && this.fileItem.getSize() == 0L) {
                this.setError(this.getMessage("file-required-error", this.getLabel()));
            } else {
                return this.invokeListener();
            }
        }
        return true;
    }

    public String toString() {
        HtmlStringBuffer buffer = new HtmlStringBuffer(96);
        buffer.elementStart("input");
        buffer.appendAttribute("type", this.getType());
        buffer.appendAttribute("name", this.getName());
        buffer.appendAttribute("id", this.getId());
        buffer.appendAttribute("value", this.getValue());
        buffer.appendAttribute("size", this.getSize());
        buffer.appendAttribute("title", this.getTitle());
        if (this.hasAttributes()) {
            buffer.appendAttributes(this.getAttributes());
        }
        if (this.isDisabled()) {
            buffer.appendAttributeDisabled();
        }
        if (this.isReadonly()) {
            buffer.appendAttributeReadonly();
        }
        if (!this.isValid()) {
            buffer.appendAttribute("class", "error");
        }
        buffer.elementEnd();
        return buffer.toString();
    }
}

