/*
 * Decompiled with CFR 0.152.
 */
package net.sf.click.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.click.Context;
import net.sf.click.control.Button;
import net.sf.click.control.Field;
import net.sf.click.control.Form;
import net.sf.click.control.Label;
import net.sf.click.util.ClickUtils;
import net.sf.click.util.HtmlStringBuffer;
import org.apache.commons.lang.StringUtils;

public class FieldSet
extends Field {
    private static final long serialVersionUID = -1811752204415596846L;
    protected final List fieldList = new ArrayList();
    protected final Map fields = new HashMap();
    protected String legend;
    protected Map legendAttributes;

    public FieldSet(String legend) {
        this.setLegend(legend);
        this.setName(ClickUtils.toName(legend));
    }

    public FieldSet(String name, String legend) {
        this.setName(name);
        this.setLegend(legend);
    }

    public FieldSet() {
    }

    public void add(Field field) {
        if (field == null) {
            throw new IllegalArgumentException("field parameter cannot be null");
        }
        if (StringUtils.isBlank((String)field.getName())) {
            throw new IllegalArgumentException("Field name not defined");
        }
        if (this.getFields().containsKey(field.getName()) && !(field instanceof Label)) {
            throw new IllegalArgumentException("Form already contains field named: " + field.getName());
        }
        if (field instanceof FieldSet) {
            throw new IllegalArgumentException("FieldSet does not support nested fieldsets");
        }
        if (field instanceof Button) {
            throw new IllegalArgumentException("FieldSet does not support Buttons");
        }
        this.getFieldList().add(field);
        this.getFields().put(field.getName(), field);
        field.setForm(this.getForm());
        if (this.getContext() != null) {
            field.setContext(this.getContext());
        }
    }

    public void remove(Field field) {
        if (field != null && this.getFields().containsKey(field.getName())) {
            field.setForm(null);
            this.getFields().remove(field.getName());
            this.getFieldList().remove(field);
        }
    }

    public void removeField(String name) {
        this.remove(this.getField(name));
    }

    public void removeFields(List fieldNames) {
        if (fieldNames != null) {
            for (int i = 0; i < fieldNames.size(); ++i) {
                this.removeField(fieldNames.get(i).toString());
            }
        }
    }

    public void setContext(Context context) {
        super.setContext(context);
        this.context = context;
        int size = this.getFieldList().size();
        for (int i = 0; i < size; ++i) {
            Field field = (Field)this.getFieldList().get(i);
            field.setContext(context);
            field.setForm(this.form);
        }
    }

    public Field getField(String name) {
        return (Field)this.fields.get(name);
    }

    public List getFieldList() {
        return this.fieldList;
    }

    public Map getFields() {
        return this.fields;
    }

    public void setForm(Form form) {
        super.setForm(form);
        int size = this.getFieldList().size();
        for (int i = 0; i < size; ++i) {
            Field field = (Field)this.getFieldList().get(i);
            field.setForm(form);
        }
    }

    public String getLegend() {
        return this.legend;
    }

    public void setLegend(String legend) {
        this.legend = legend;
    }

    public String getLegendAttribute(String name) {
        if (this.legendAttributes != null) {
            return (String)this.legendAttributes.get(name);
        }
        return null;
    }

    public void setLegendAttribute(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Null name parameter");
        }
        if (this.legendAttributes == null) {
            this.legendAttributes = new HashMap(5);
        }
        if (value != null) {
            this.legendAttributes.put(name, value);
        } else {
            this.legendAttributes.remove(name);
        }
    }

    public Map getLegendAttributes() {
        if (this.legendAttributes == null) {
            this.legendAttributes = new HashMap(5);
        }
        return this.legendAttributes;
    }

    public boolean hasLegendAttributes() {
        return this.legendAttributes != null && !this.legendAttributes.isEmpty();
    }

    public void setListener(Object listener, String method) {
        throw new UnsupportedOperationException("setListener not supported");
    }

    public boolean isValid() {
        int size = this.getFieldList().size();
        for (int i = 0; i < size; ++i) {
            Field field = (Field)this.getFieldList().get(i);
            if (field.isValid()) continue;
            return false;
        }
        return true;
    }

    public boolean onProcess() {
        int size = this.getFieldList().size();
        for (int i = 0; i < size; ++i) {
            Field field = (Field)this.getFieldList().get(i);
            boolean continueProcessing = field.onProcess();
            if (continueProcessing) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int bufferSize = 160 + this.fieldList.size() * 350;
        HtmlStringBuffer buffer = new HtmlStringBuffer(bufferSize);
        buffer.elementStart("fieldset");
        buffer.appendAttribute("id", this.getId());
        if (this.hasAttributes()) {
            buffer.appendAttributes(this.getAttributes());
        }
        if (this.isDisabled()) {
            buffer.appendAttributeDisabled();
        }
        buffer.closeTag();
        buffer.append("\n");
        if (this.getLegend() != null) {
            buffer.elementStart("legend");
            buffer.appendAttribute("id", this.getId() + "-legend");
            if (this.hasLegendAttributes()) {
                buffer.appendAttributes(this.getLegendAttributes());
            }
            buffer.closeTag();
            buffer.append(this.getLegend());
            buffer.elementEnd("legend");
            buffer.append("\n");
        }
        this.renderFields(buffer);
        buffer.elementEnd("fieldset");
        buffer.append("\n");
        return buffer.toString();
    }

    protected void renderFields(HtmlStringBuffer buffer) {
        if (this.getFieldList().isEmpty()) {
            return;
        }
        buffer.elementStart("table");
        buffer.appendAttribute("class", "fields");
        buffer.appendAttribute("id", this.getId() + "-fields");
        buffer.closeTag();
        buffer.append("\n");
        int column = 1;
        int size = this.fieldList.size();
        for (int i = 0; i < size; ++i) {
            Field field = (Field)this.fieldList.get(i);
            if (field.isHidden()) {
                buffer.append(field.toString());
                buffer.append("\n");
                continue;
            }
            if (column == 1) {
                buffer.append("<tr class=\"fields\">\n");
            }
            if (field instanceof Label) {
                buffer.append("<td class=\"fields\" colspan=\"2\" align=\"");
                buffer.append(this.getForm().getLabelAlign());
                buffer.append("\"");
                if (field.hasAttributes()) {
                    buffer.appendAttributes(field.getAttributes());
                }
                buffer.append(">");
                buffer.append(field);
                buffer.append("</td>\n");
            } else {
                if ("left".equals(this.getForm().getLabelsPosition())) {
                    buffer.append("<td class=\"fields\" align=\"");
                    buffer.append(this.getForm().getLabelAlign());
                    buffer.append("\">");
                } else {
                    buffer.append("<td class=\"fields\" valign=\"top\">");
                }
                if (field.isRequired()) {
                    buffer.append(Form.labelRequiredPrefix);
                }
                buffer.elementStart("label");
                if (field.isDisabled()) {
                    buffer.appendAttributeDisabled();
                }
                if (field.getError() != null) {
                    buffer.appendAttribute("class", "error");
                }
                buffer.closeTag();
                buffer.append(field.getLabel());
                buffer.elementEnd("label");
                if (field.isRequired()) {
                    buffer.append(Form.labelRequiredSuffix);
                }
                if ("left".equals(this.getForm().getLabelsPosition())) {
                    buffer.append("</td>\n");
                    buffer.append("<td align=\"left\">");
                } else {
                    buffer.append("<br/>");
                }
                buffer.append(field);
                buffer.append("</td>\n");
            }
            if (column == this.getForm().getColumns()) {
                buffer.append("</tr>\n");
                column = 1;
                continue;
            }
            ++column;
        }
        buffer.elementEnd("table");
        buffer.append("\n");
    }
}

