/*
 * Decompiled with CFR 0.152.
 */
package net.sf.click.control;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import net.sf.click.Context;
import net.sf.click.Control;
import net.sf.click.control.Form;
import net.sf.click.util.ClickUtils;

public abstract class Field
implements Control {
    protected static final String CONTROL_MESSAGES = "click-control";
    protected Map attributes;
    protected Context context;
    protected boolean disabled;
    protected String error;
    protected boolean focus;
    protected Form form;
    protected String label;
    protected Object listener;
    protected String listenerMethod;
    protected String name;
    protected boolean readonly;
    protected boolean required;
    protected String title;
    protected String value;

    public Field() {
    }

    public Field(String label) {
        this.setLabel(label);
        this.setName(ClickUtils.toName(label));
    }

    public Field(String name, String label) {
        this.setName(name);
        this.setLabel(label);
    }

    public String getAttribute(String name) {
        if (this.attributes != null) {
            return (String)this.attributes.get(name);
        }
        return null;
    }

    public void setAttribute(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Null name parameter");
        }
        if (this.attributes == null) {
            this.attributes = new HashMap(5);
        }
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    public Map getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap(5);
        }
        return this.attributes;
    }

    public boolean hasAttributes() {
        return this.attributes != null && !this.attributes.isEmpty();
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        String key;
        if (context == null) {
            throw new IllegalArgumentException("Null context parameter");
        }
        this.context = context;
        if (this.getLabel() != null && this.getLabel().startsWith("msg:")) {
            key = this.getLabel().substring(4);
            this.setLabel(this.getMessage(key));
        }
        if (this.getTitle() != null && this.getTitle().startsWith("msg:")) {
            key = this.getTitle().substring(4);
            this.setTitle(this.getMessage(key));
        }
    }

    public boolean isDisabled() {
        if (this.getForm() != null && this.getForm().isDisabled()) {
            return true;
        }
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public boolean getFocus() {
        return this.focus;
    }

    public void setFocus(boolean focus) {
        this.focus = focus;
    }

    public Form getForm() {
        return this.form;
    }

    public void setForm(Form form) {
        this.form = form;
    }

    public boolean isHidden() {
        return false;
    }

    public String getId() {
        String formId;
        String string = formId = this.getForm() != null ? this.getForm().getId() + "-" : "";
        if (this.hasAttributes() && this.getAttributes().containsKey("id")) {
            return formId + this.getAttribute("id");
        }
        return formId + this.getName();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setListener(Object target, String methodName) {
        this.listener = target;
        this.listenerMethod = methodName;
    }

    public String getMessage(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name parameter");
        }
        Locale locale = this.getContext().getLocale();
        ResourceBundle bundle = ResourceBundle.getBundle(CONTROL_MESSAGES, locale);
        return bundle.getString(name);
    }

    public String getMessage(String name, Object arg) {
        Object[] args = new Object[]{arg};
        return this.getMessage(name, args);
    }

    public String getMessage(String name, Object[] args) {
        if (args == null) {
            throw new IllegalArgumentException("Null args parameter");
        }
        String value = this.getMessage(name);
        return MessageFormat.format(value, args);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name parameter");
        }
        this.name = name;
    }

    public boolean isReadonly() {
        if (this.getForm() != null && this.getForm().isReadonly()) {
            return true;
        }
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public boolean validate() {
        if (this.getForm() != null) {
            return this.getForm().getValidate();
        }
        return true;
    }

    public boolean isValid() {
        return this.error == null;
    }

    public String getValue() {
        return this.value != null ? this.value : "";
    }

    public void setValue(Object value) {
        if (value != null) {
            this.value = value.toString();
        }
    }

    protected boolean invokeListener() {
        if (this.listener != null && this.listenerMethod != null) {
            return ClickUtils.invokeListener(this.listener, this.listenerMethod);
        }
        return true;
    }

    protected String getRequestValue() {
        String value = this.getContext().getRequestParameter(this.getName());
        if (value != null) {
            return value.trim();
        }
        return "";
    }
}

