/*
 * Decompiled with CFR 0.152.
 */
package net.sf.click.control;

import net.sf.click.control.TextField;

public class EmailField
extends TextField {
    private static final long serialVersionUID = 7526447883893011813L;

    public EmailField(String label) {
        super(label);
        this.setSize(30);
    }

    public EmailField(String name, String label) {
        super(name, label);
        this.setSize(30);
    }

    public EmailField(String label, boolean required) {
        this(label);
        this.size = 30;
    }

    public EmailField() {
        this.setSize(30);
    }

    public boolean onProcess() {
        this.value = this.getRequestValue();
        if (!this.validate()) {
            return true;
        }
        int length = this.value.length();
        if (length > 0) {
            if (this.getMinLength() > 0 && length < this.getMinLength()) {
                Object[] args = new Object[]{this.getLabel(), new Integer(this.getMinLength())};
                this.setError(this.getMessage("field-minlength-error", args));
                return true;
            }
            if (this.getMaxLength() > 0 && length > this.getMaxLength()) {
                Object[] args = new Object[]{this.getLabel(), new Integer(this.getMaxLength())};
                this.setError(this.getMessage("field-maxlength-error", args));
                return true;
            }
            int index = this.value.indexOf("@");
            if (index < 1 || index == length - 1) {
                this.setError(this.getMessage("email-format-error", this.getLabel()));
                return true;
            }
            if (!Character.isLetterOrDigit(this.value.charAt(0))) {
                this.setError(this.getMessage("email-format-error", this.getLabel()));
                return true;
            }
            if (!Character.isLetterOrDigit(this.value.charAt(length - 1))) {
                this.setError(this.getMessage("email-format-error", this.getLabel()));
                return true;
            }
            return this.invokeListener();
        }
        if (this.isRequired()) {
            this.setError(this.getMessage("field-required-error", this.getLabel()));
        }
        return true;
    }
}

