/*
 * Decompiled with CFR 0.152.
 */
package net.sf.click.control;

import net.sf.click.control.TextField;

public class DoubleField
extends TextField {
    private static final long serialVersionUID = -6326214893690121356L;
    protected double maxvalue = Double.MAX_VALUE;
    protected double minvalue = Double.MIN_VALUE;

    public DoubleField(String label) {
        super(label);
        this.setAttribute("onKeyPress", "javascript:return doubleFilter(event);");
    }

    public DoubleField(String name, String label) {
        super(name, label);
        this.setAttribute("onKeyPress", "javascript:return doubleFilter(event);");
    }

    public DoubleField(String label, boolean required) {
        this(label);
        this.setRequired(required);
    }

    public DoubleField() {
        this.setAttribute("onKeyPress", "javascript:return doubleFilter(event);");
    }

    public Double getDouble() {
        String value = this.getValue();
        if (value != null && value.length() > 0) {
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        return null;
    }

    public Float getFloat() {
        String value = this.getValue();
        if (value != null && value.length() > 0) {
            try {
                return Float.valueOf(value);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        return null;
    }

    public double getMaxValue() {
        return this.maxvalue;
    }

    public void setMaxValue(double value) {
        this.maxvalue = value;
    }

    public void setMinValue(double value) {
        this.minvalue = value;
    }

    public double getMinValue() {
        return this.minvalue;
    }

    public boolean onProcess() {
        this.value = this.getRequestValue();
        if (!this.validate()) {
            return true;
        }
        int length = this.value.length();
        if (length > 0) {
            try {
                double doubleValue = Double.parseDouble(this.value);
                if (this.maxvalue != Double.MAX_VALUE && doubleValue > this.maxvalue) {
                    Object[] args = new Object[]{this.getLabel(), new Double(this.maxvalue)};
                    this.setError(this.getMessage("number-maxvalue-error", args));
                    return true;
                }
                if (this.minvalue != Double.MIN_VALUE && doubleValue < this.minvalue) {
                    Object[] args = new Object[]{this.getLabel(), new Double(this.minvalue)};
                    this.setError(this.getMessage("number-minvalue-error", args));
                    return true;
                }
                return this.invokeListener();
            }
            catch (NumberFormatException nfe) {
                this.setError(this.getMessage("double-format-error", this.getLabel()));
            }
        } else if (this.isRequired()) {
            this.setError(this.getMessage("field-required-error", this.getLabel()));
        }
        return true;
    }
}

