/*
 * Decompiled with CFR 0.152.
 */
package net.sf.click.control;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.click.control.TextField;
import net.sf.click.util.HtmlStringBuffer;

public class DateField
extends TextField {
    private static final long serialVersionUID = 3379108282465075759L;
    protected String calendarPattern;
    protected SimpleDateFormat dateFormat;
    protected String formatPattern;
    protected boolean showTime;

    public DateField(String label) {
        super(label);
        this.setAttribute("id", this.getName() + "-field");
        this.setFormatPattern("dd MMM yyyy");
    }

    public DateField(String name, String label) {
        super(name, label);
        this.setAttribute("id", this.getName() + "-field");
        this.setFormatPattern("dd MMM yyyy");
    }

    public DateField(String label, boolean required) {
        this(label);
        this.setRequired(required);
    }

    public DateField() {
        this.setFormatPattern("dd MMM yyyy");
    }

    public String getCalendarPattern() {
        return this.calendarPattern;
    }

    public Date getDate() {
        if (this.value != null || this.value.length() > 0) {
            try {
                Date date = this.getDateFormat().parse(this.value);
                return new Date(date.getTime());
            }
            catch (ParseException pe) {
                return null;
            }
        }
        return null;
    }

    public void setDate(Date date) {
        if (date != null) {
            this.value = this.getDateFormat().format(date);
        }
    }

    public SimpleDateFormat getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat(this.formatPattern);
        }
        return this.dateFormat;
    }

    public String getFormatPattern() {
        return this.formatPattern;
    }

    public void setFormatPattern(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Null pattern parameter");
        }
        this.formatPattern = pattern;
        this.calendarPattern = this.parseDateFormatPattern(pattern);
    }

    public void setName(String name) {
        super.setName(name);
        this.setAttribute("id", this.getName() + "-field");
    }

    public Timestamp getTimestamp() {
        Date date = this.getDate();
        if (date != null) {
            return new Timestamp(date.getTime());
        }
        return null;
    }

    public boolean getShowTime() {
        return this.showTime;
    }

    public void setShowTime(boolean showTime) {
        this.showTime = showTime;
    }

    public boolean onProcess() {
        if (this.formatPattern == null) {
            throw new IllegalStateException("dateFormat attribute is null");
        }
        this.value = this.getRequestValue();
        if (!this.validate()) {
            return true;
        }
        int length = this.value.length();
        if (length > 0) {
            if (this.getMinLength() > 0 && length < this.getMinLength()) {
                Object[] args = new Object[]{this.getLabel(), new Integer(this.getMinLength())};
                this.setError(this.getMessage("field-minlength-error", args));
                return true;
            }
            if (this.getMaxLength() > 0 && length > this.getMaxLength()) {
                Object[] args = new Object[]{this.getLabel(), new Integer(this.getMaxLength())};
                this.setError(this.getMessage("field-maxlength-error", args));
                return true;
            }
            SimpleDateFormat dateFormat = this.getDateFormat();
            dateFormat.setLenient(false);
            boolean parsedOk = false;
            try {
                dateFormat.parse(this.value).getTime();
                parsedOk = true;
            }
            catch (ParseException pe) {
                Object[] args = new Object[]{this.getLabel(), this.formatPattern};
                this.setError(this.getMessage("date-format-error", args));
            }
            if (parsedOk) {
                return this.invokeListener();
            }
            return true;
        }
        if (this.isRequired()) {
            this.setError(this.getMessage("field-required-error", this.getLabel()));
        }
        return true;
    }

    public String toString() {
        HtmlStringBuffer buffer = new HtmlStringBuffer();
        String textField = super.toString();
        buffer.append(textField);
        if (!this.isReadonly() && !this.isDisabled()) {
            buffer.append("<img align=\"middle\" hspace=\"2\" style=\"cursor:hand\" src=\"");
            buffer.append(this.getForm().getContext().getRequest().getContextPath());
            buffer.append("/click/calendar.gif\" id=\"");
            buffer.append(this.getId());
            buffer.append("-button\" ");
            String calendarTitle = this.getMessage("calendar-image-title");
            buffer.appendAttribute("alt", calendarTitle);
            buffer.appendAttribute("title", calendarTitle);
            buffer.elementEnd();
            buffer.append("<script type=\"text/javascript\">\n");
            buffer.append("Calendar.setup({ \n");
            buffer.append(" inputField :  '");
            buffer.append(this.getId());
            buffer.append("', \n");
            buffer.append(" ifFormat :    '");
            buffer.append(this.getCalendarPattern());
            buffer.append("', \n");
            if (this.getShowTime()) {
                buffer.append(" showsTime : true, \n");
            }
            buffer.append(" button :      '");
            buffer.append(this.getId());
            buffer.append("-button', \n");
            buffer.append(" align :       'cr', \n");
            buffer.append(" singleClick : true \n");
            buffer.append("});\n");
            buffer.append("</script> \n");
        }
        return buffer.toString();
    }

    protected String parseDateFormatPattern(String pattern) {
        StringBuffer jsPattern = new StringBuffer(20);
        int tokenStart = -1;
        int tokenEnd = -1;
        boolean debug = false;
        for (int i = 0; i < pattern.length(); ++i) {
            char aChar = pattern.charAt(i);
            if (debug) {
                System.err.print("[" + i + "," + tokenStart + "," + tokenEnd + "]=" + aChar);
            }
            if ("GyMwWDdFEaHkKhmsSzZ".indexOf(aChar) == -1) {
                if (debug) {
                    System.err.println(" N");
                }
                if (tokenStart > -1) {
                    tokenEnd = i;
                }
            } else {
                if (debug) {
                    System.err.println(" Y");
                }
                if (tokenStart == -1) {
                    tokenStart = i;
                }
            }
            if (tokenStart > -1) {
                if (tokenEnd == -1 && i == pattern.length() - 1) {
                    tokenEnd = pattern.length();
                }
                if (tokenEnd > -1) {
                    String token = pattern.substring(tokenStart, tokenEnd);
                    if ("yyyy".equals(token)) {
                        jsPattern.append("%Y");
                    } else if ("yy".equals(token)) {
                        jsPattern.append("%y");
                    } else if ("MMMM".equals(token)) {
                        jsPattern.append("%B");
                    } else if ("MMM".equals(token)) {
                        jsPattern.append("%b");
                    } else if ("MM".equals(token)) {
                        jsPattern.append("%m");
                    } else if ("dd".equals(token)) {
                        jsPattern.append("%e");
                    } else if ("EEEE".equals(token)) {
                        jsPattern.append("%A");
                    } else if ("EEE".equals(token)) {
                        jsPattern.append("%a");
                    } else if ("EE".equals(token)) {
                        jsPattern.append("%a");
                    } else if ("E".equals(token)) {
                        jsPattern.append("%a");
                    } else if ("aaa".equals(token)) {
                        jsPattern.append("%p");
                    } else if ("aa".equals(token)) {
                        jsPattern.append("%p");
                    } else if ("a".equals(token)) {
                        jsPattern.append("%p");
                    } else if ("HH".equals(token)) {
                        jsPattern.append("%H");
                        this.setShowTime(true);
                    } else if ("H".equals(token)) {
                        jsPattern.append("%H");
                        this.setShowTime(true);
                    } else if ("hh".equals(token)) {
                        jsPattern.append("%l");
                        this.setShowTime(true);
                    } else if ("h".equals(token)) {
                        jsPattern.append("%l");
                        this.setShowTime(true);
                    } else if ("mm".equals(token)) {
                        jsPattern.append("%M");
                        this.setShowTime(true);
                    } else if ("m".equals(token)) {
                        jsPattern.append("%M");
                        this.setShowTime(true);
                    } else if ("ss".equals(token)) {
                        jsPattern.append("%S");
                        this.setShowTime(true);
                    } else if ("s".equals(token)) {
                        jsPattern.append("%S");
                        this.setShowTime(true);
                    } else if (debug) {
                        System.err.println("Not mapped:" + token);
                    }
                    if (debug) {
                        System.err.println("token[" + tokenStart + "," + tokenEnd + "]='" + token + "'");
                    }
                    tokenStart = -1;
                    tokenEnd = -1;
                }
            }
            if (tokenStart != -1 || tokenEnd != -1 || "GyMwWDdFEaHkKhmsSzZ".indexOf(aChar) != -1) continue;
            jsPattern.append(aChar);
        }
        return jsPattern.toString();
    }
}

