/*
 * Decompiled with CFR 0.152.
 */
package net.sf.click.control;

import java.util.ArrayList;
import java.util.List;
import net.sf.click.control.Option;
import net.sf.click.control.Select;
import net.sf.click.control.TextField;
import net.sf.click.util.ClickUtils;

public class CreditCardField
extends TextField {
    private static final long serialVersionUID = -4591403023871778803L;
    public static final String VISA = "VISA";
    public static final String MASTER = "MASTER";
    public static final String AMEX = "AMEX";
    public static final String DINERS = "DINERS";
    public static final String DISCOVER = "DISCOVER";
    protected static final List CARD_OPTIONS = new ArrayList();
    protected static final String SELECT_NAME = "cardtype";
    protected String cardType = "VISA";
    protected Select cardTypeSelect = new Select("cardtype");

    public CreditCardField(String label) {
        this(ClickUtils.toName(label), label);
    }

    public CreditCardField(String name, String label) {
        super(name, label);
        this.setMaxLength(19);
        this.setSize(19);
        this.setAttribute("onKeyPress", "javascript:return integerFilter(event);");
        this.cardTypeSelect.addAll(CARD_OPTIONS);
    }

    public CreditCardField(String label, boolean required) {
        this(label);
        this.setRequired(required);
    }

    public CreditCardField() {
        this.setMaxLength(19);
        this.setSize(19);
        this.setAttribute("onKeyPress", "javascript:return integerFilter(event);");
        this.cardTypeSelect.addAll(CARD_OPTIONS);
    }

    public String getCardType() {
        return this.cardType;
    }

    public Long getCardNumber() {
        String value = this.getValue();
        if (value != null && value.length() > 0) {
            return Long.valueOf(value);
        }
        return null;
    }

    public boolean onProcess() {
        this.value = this.getRequestValue();
        this.cardType = this.getContext().getRequestParameter(SELECT_NAME);
        if (!this.validate()) {
            return true;
        }
        StringBuffer buffer = new StringBuffer(this.value.length());
        int size = this.value.length();
        for (int i = 0; i < size; ++i) {
            char aChar = this.value.charAt(i);
            if (aChar == '-' || aChar == ' ') continue;
            buffer.append(aChar);
        }
        this.value = buffer.toString();
        int length = this.value.length();
        if (length > 0) {
            if (length < this.getMinLength()) {
                Object[] args = new Object[]{this.getLabel(), new Integer(this.getMinLength())};
                this.setError(this.getMessage("field-minlength-error", args));
                return true;
            }
            if (length > this.getMaxLength()) {
                Object[] args = new Object[]{this.getLabel(), new Integer(this.getMaxLength())};
                this.setError(this.getMessage("field-maxlength-error", args));
                return true;
            }
            if (length < 13) {
                this.setError(this.getMessage("creditcard-number-error", this.getLabel()));
                return true;
            }
            if (this.cardType != null) {
                char firstdig = this.value.charAt(0);
                char seconddig = this.value.charAt(1);
                boolean isValid = false;
                if (this.cardType.equals(VISA)) {
                    isValid = (length == 16 || length == 13) && firstdig == '4';
                } else if (this.cardType.equals(MASTER)) {
                    isValid = length == 16 && firstdig == '5' && "12345".indexOf(seconddig) >= 0;
                } else if (this.cardType.equals(AMEX)) {
                    isValid = length == 15 && firstdig == '3' && "47".indexOf(seconddig) >= 0;
                } else if (this.cardType.equals(DINERS)) {
                    isValid = length == 14 && firstdig == '3' && "068".indexOf(seconddig) >= 0;
                } else if (this.cardType.equals(DISCOVER)) {
                    boolean bl = isValid = length == 16 && this.value.startsWith("6011");
                }
                if (!isValid) {
                    this.setError(this.getMessage("creditcard-number-error", this.getLabel()));
                }
            }
            return this.invokeListener();
        }
        if (this.isRequired()) {
            this.setError(this.getMessage("field-required-error", this.getLabel()));
        }
        return true;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(400);
        String textField = super.toString();
        buffer.append(textField);
        this.cardTypeSelect.setContext(this.getContext());
        this.cardTypeSelect.setValue(this.cardType);
        this.cardTypeSelect.setForm(this.getForm());
        buffer.append(this.cardTypeSelect);
        return buffer.toString();
    }

    static {
        CARD_OPTIONS.add(new Option(VISA, "Visa"));
        CARD_OPTIONS.add(new Option(MASTER, "Master"));
        CARD_OPTIONS.add(new Option(AMEX, "AmEx"));
        CARD_OPTIONS.add(new Option(DINERS, "Diners"));
        CARD_OPTIONS.add(new Option(DISCOVER, "Discover"));
    }
}

