/*
 * Decompiled with CFR 0.152.
 */
package net.sf.click.control;

import net.sf.click.control.Field;
import net.sf.click.util.HtmlStringBuffer;

public class Checkbox
extends Field {
    private static final long serialVersionUID = -6767031397352259579L;
    protected boolean checked;

    public Checkbox(String label) {
        super(label);
    }

    public Checkbox(String name, String label) {
        super(name, label);
    }

    public Checkbox(String label, boolean required) {
        super(label);
        this.setRequired(required);
    }

    public Checkbox() {
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean value) {
        this.checked = value;
    }

    public String getType() {
        return "checkbox";
    }

    public String getValue() {
        return String.valueOf(this.checked);
    }

    public void setValue(Object value) {
        this.checked = value != null ? Boolean.valueOf(value.toString()) : false;
    }

    public boolean onProcess() {
        this.setChecked(this.getContext().getRequestParameter(this.getName()) != null);
        if (!this.validate()) {
            return true;
        }
        if (this.isRequired() && !this.isChecked()) {
            this.error = this.getMessage("not-checked-error", this.getLabel());
        }
        return this.invokeListener();
    }

    public String toString() {
        HtmlStringBuffer buffer = new HtmlStringBuffer();
        buffer.elementStart("input");
        buffer.appendAttribute("type", this.getType());
        buffer.appendAttribute("name", this.getName());
        buffer.appendAttribute("id", this.getId());
        buffer.appendAttribute("title", this.getTitle());
        if (this.isChecked()) {
            buffer.appendAttribute("checked", "checked");
        }
        if (this.hasAttributes()) {
            buffer.appendAttributes(this.getAttributes());
        }
        if (this.isDisabled()) {
            buffer.appendAttributeDisabled();
        }
        if (this.isReadonly()) {
            buffer.appendAttributeReadonly();
        }
        if (!this.isValid()) {
            buffer.appendAttribute("class", "error");
        }
        buffer.elementEnd();
        return buffer.toString();
    }
}

