/*
 * Decompiled with CFR 0.152.
 */
package net.sf.click.control;

import net.sf.click.control.Field;
import net.sf.click.util.ClickUtils;
import net.sf.click.util.HtmlStringBuffer;

public class Button
extends Field {
    private static final long serialVersionUID = -4565346013990356183L;

    public Button(String value) {
        this.setValue(value);
        this.setName(ClickUtils.toName(value));
    }

    public Button() {
    }

    public String getOnClick() {
        if (this.attributes != null) {
            return (String)this.attributes.get("onclick");
        }
        return null;
    }

    public void setOnClick(String value) {
        this.setAttribute("onclick", value);
    }

    public String getType() {
        return "button";
    }

    public boolean onProcess() {
        return true;
    }

    public String toString() {
        HtmlStringBuffer buffer = new HtmlStringBuffer(40);
        buffer.elementStart("input");
        buffer.appendAttribute("type", this.getType());
        buffer.appendAttribute("name", this.getName());
        buffer.appendAttribute("id", this.getId());
        buffer.appendAttribute("value", this.getValue());
        buffer.appendAttribute("title", this.getTitle());
        if (this.hasAttributes()) {
            buffer.appendAttributes(this.getAttributes());
        }
        if (this.isDisabled()) {
            buffer.appendAttributeDisabled();
        }
        buffer.elementEnd();
        return buffer.toString();
    }
}

