/*
 * Decompiled with CFR 0.152.
 */
package net.sf.click.control;

import java.util.HashMap;
import java.util.Map;
import net.sf.click.Context;
import net.sf.click.Control;
import net.sf.click.util.ClickUtils;
import net.sf.click.util.HtmlStringBuffer;
import org.apache.commons.lang.StringUtils;

public class ActionLink
implements Control {
    private static final long serialVersionUID = 8469056846426557956L;
    public static final String ACTION_LINK = "actionLink";
    public static final String VALUE = "value";
    protected Map attributes;
    protected boolean clicked;
    protected Context context;
    protected boolean disabled;
    protected String name;
    protected String label;
    protected Object listener;
    protected String listenerMethod;
    protected String value;

    public ActionLink(String name) {
        this.setName(name);
    }

    public ActionLink(String name, Object listener, String method) {
        this.setName(name);
        if (listener == null) {
            throw new IllegalArgumentException("Null listener parameter");
        }
        if (StringUtils.isBlank((String)method)) {
            throw new IllegalArgumentException("Blank listener method");
        }
        this.setListener(listener, method);
    }

    public ActionLink() {
    }

    public String getAttribute(String name) {
        if (this.attributes != null) {
            return (String)this.attributes.get(name);
        }
        return null;
    }

    public void setAttribute(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Null name parameter");
        }
        if (this.attributes == null) {
            this.attributes = new HashMap(5);
        }
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    public Map getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap(5);
        }
        return this.attributes;
    }

    public boolean hasAttributes() {
        return this.attributes != null && !this.attributes.isEmpty();
    }

    public boolean isClicked() {
        return this.clicked;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Null context parameter");
        }
        this.context = context;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public String getHref(Object value) {
        String uri = this.getContext().getRequest().getRequestURI();
        StringBuffer buffer = new StringBuffer(uri.length() + this.getName().length() + 40);
        buffer.append(uri);
        buffer.append("?");
        buffer.append(ACTION_LINK);
        buffer.append("=");
        buffer.append(this.getName());
        if (value != null) {
            buffer.append("&amp;");
            buffer.append(VALUE);
            buffer.append("=");
            buffer.append(value);
        }
        return this.getContext().getResponse().encodeURL(buffer.toString());
    }

    public String getHref() {
        return this.getHref(this.getValue());
    }

    public String getId() {
        if (this.hasAttributes() && this.getAttributes().containsKey("id")) {
            return this.getAttribute("id");
        }
        return this.getName();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name parameter");
        }
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public Double getValueDouble() {
        if (this.value != null) {
            return Double.valueOf(this.value);
        }
        return null;
    }

    public Integer getValueInteger() {
        if (this.value != null) {
            return Integer.valueOf(this.value);
        }
        return null;
    }

    public Long getValueLong() {
        if (this.value != null) {
            return Long.valueOf(this.value);
        }
        return null;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setListener(Object target, String methodName) {
        this.listener = target;
        this.listenerMethod = methodName;
    }

    public boolean onProcess() {
        this.clicked = this.getName().equals(this.getContext().getRequestParameter(ACTION_LINK));
        if (this.clicked) {
            this.value = this.getContext().getRequestParameter(VALUE);
            if (this.listener != null && this.listenerMethod != null) {
                return ClickUtils.invokeListener(this.listener, this.listenerMethod);
            }
            return true;
        }
        return true;
    }

    public String toString() {
        HtmlStringBuffer buffer = new HtmlStringBuffer();
        buffer.elementStart("a");
        buffer.append(" href=\"");
        buffer.append(this.getHref());
        buffer.append("\"");
        buffer.appendAttribute("id", this.getId());
        if (this.hasAttributes()) {
            buffer.appendAttributes(this.getAttributes());
        }
        if (this.isDisabled()) {
            buffer.appendAttributeDisabled();
        }
        buffer.closeTag();
        buffer.appendEscaped(this.getLabel());
        buffer.elementEnd("a");
        return buffer.toString();
    }
}

