/*
 * Decompiled with CFR 0.152.
 */
package net.sf.click;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import net.sf.click.Context;
import net.sf.click.Control;
import org.apache.commons.lang.StringUtils;

public class Page {
    protected Context context;
    protected List controls;
    protected Object format;
    protected String forward;
    protected Map headers;
    protected boolean headersEdited;
    protected ResourceBundle messages;
    protected Map model = new HashMap();
    protected String path;
    protected String redirect;

    public void addControl(Control control) {
        if (control == null) {
            throw new IllegalArgumentException("Null control parameter");
        }
        if (StringUtils.isBlank((String)control.getName())) {
            throw new IllegalArgumentException("Control name not defined");
        }
        if (this.controls == null) {
            this.controls = new ArrayList();
        }
        this.controls.add(control);
        if (this.getContext() != null) {
            control.setContext(this.getContext());
        }
        this.addModel(control.getName(), control);
    }

    public List getControls() {
        if (this.controls == null) {
            this.controls = new ArrayList();
        }
        return this.controls;
    }

    public boolean hasControls() {
        return this.controls == null ? false : !this.controls.isEmpty();
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Null context parameter");
        }
        this.context = context;
        if (!this.getModel().isEmpty()) {
            Iterator i = this.getModel().values().iterator();
            while (i.hasNext()) {
                Object object = i.next();
                if (!(object instanceof Control)) continue;
                ((Control)object).setContext(context);
            }
        }
    }

    public String getContentType() {
        return "text/html";
    }

    public Object getFormat() {
        return this.format;
    }

    public void setFormat(Object value) {
        this.format = value;
    }

    public String getForward() {
        return this.forward;
    }

    public void setForward(String value) {
        this.forward = value;
    }

    public void setForward(Page page) {
        if (page == null) {
            throw new IllegalArgumentException("Null page parameter");
        }
        if (page.getPath() == null) {
            throw new IllegalArgumentException("Page has no path defined");
        }
        this.setForward(page.getPath());
        this.getContext().setRequestAttribute("forward-page", page);
    }

    public Map getHeaders() {
        return this.headers;
    }

    public void setHeader(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("Null header name parameter");
        }
        if (!this.headersEdited) {
            this.headersEdited = true;
            this.headers = new HashMap(this.headers);
        }
        this.headers.put(name, value);
    }

    public void setHeaders(Map value) {
        this.headers = value;
    }

    public String getMessage(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Null key parameter");
        }
        if (this.messages == null) {
            Locale locale = this.getContext().getLocale();
            this.messages = ResourceBundle.getBundle(this.getClass().getName(), locale);
        }
        return this.messages.getString(key);
    }

    public void addModel(String name, Object value) {
        if (name == null) {
            String msg = "Cannot add null parameter name to " + this.getClass().getName() + " model";
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "Cannot add null " + name + " parameter " + "to " + this.getClass().getName() + " model";
            throw new IllegalArgumentException(msg);
        }
        if (this.getModel().containsKey(name)) {
            String msg = this.getClass().getName() + " model already contains " + "value named " + name;
            throw new IllegalArgumentException(msg);
        }
        this.getModel().put(name, value);
    }

    public Map getModel() {
        return this.model;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String value) {
        this.path = value;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public void setRedirect(String location) {
        this.redirect = location;
    }

    public String getTemplate() {
        return this.getPath();
    }

    public void onInit() {
    }

    public boolean onSecurityCheck() {
        return true;
    }

    public void onGet() {
    }

    public void onPost() {
    }

    public void onDestroy() {
    }
}

