/*
 * Decompiled with CFR 0.152.
 */
package net.sf.click;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.click.ClickServlet;
import net.sf.click.Page;
import net.sf.click.util.ClickUtils;
import org.apache.commons.fileupload.DefaultFileItemFactory;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;

public class Context {
    public static final String LOCALE = "locale";
    protected final ServletContext context;
    protected final ServletConfig config;
    protected Map multiPartFormData;
    protected final ClickServlet.PageMaker pageMaker;
    protected final HttpServletRequest request;
    protected final HttpServletResponse response;
    protected HttpSession session;
    protected final boolean isPost;

    public Context(ServletContext context, ServletConfig config, HttpServletRequest request, HttpServletResponse response, boolean isPost, ClickServlet.PageMaker pageMaker) {
        this.context = context;
        this.config = config;
        this.request = request;
        this.response = response;
        this.isPost = isPost;
        this.pageMaker = pageMaker;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public HttpSession getSession() {
        if (this.session == null) {
            this.session = this.request.getSession();
        }
        return this.session;
    }

    public String getResourcePath() {
        return ClickUtils.getResourcePath(this.request);
    }

    public boolean isForward() {
        return this.request.getAttribute("click-forward") != null;
    }

    public boolean isPost() {
        return this.isPost;
    }

    public Object getRequestAttribute(String name) {
        return this.request.getAttribute(name);
    }

    public void setRequestAttribute(String name, Object value) {
        this.request.setAttribute(name, value);
    }

    public String getRequestParameter(String name) {
        if (this.isMultipartRequest()) {
            FileItem fileItem;
            if (this.multiPartFormData == null) {
                FileUpload fileUpload = new FileUpload();
                fileUpload.setFileItemFactory((FileItemFactory)new DefaultFileItemFactory());
                try {
                    List itemsList = fileUpload.parseRequest(this.request);
                    HashMap<String, FileItem> itemsMap = new HashMap<String, FileItem>(itemsList.size());
                    for (int i = 0; i < itemsList.size(); ++i) {
                        FileItem fileItem2 = (FileItem)itemsList.get(i);
                        itemsMap.put(fileItem2.getFieldName(), fileItem2);
                    }
                    this.multiPartFormData = itemsMap;
                }
                catch (FileUploadException fue) {
                    throw new RuntimeException(fue);
                }
            }
            if ((fileItem = (FileItem)this.multiPartFormData.get(name)) != null) {
                return fileItem.getString();
            }
            return null;
        }
        return this.request.getParameter(name);
    }

    public Object getSessionAttribute(String name) {
        if (this.hasSession()) {
            return this.getSession().getAttribute(name);
        }
        return null;
    }

    public void setSessionAttribute(String name, Object value) {
        this.getSession().setAttribute(name, value);
    }

    public void removeSessionAttribute(String name) {
        if (this.hasSession() && name != null) {
            this.getSession().removeAttribute(name);
        }
    }

    public boolean hasSessionAttribute(String name) {
        return this.getSessionAttribute(name) != null;
    }

    public Object getSessionObject(Class aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Null class parameter.");
        }
        Object object = this.getSessionAttribute(aClass.getName());
        if (object == null) {
            try {
                object = aClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return object;
    }

    public void setSessionObject(Object object) {
        if (object != null) {
            this.setSessionAttribute(object.getClass().getName(), object);
        }
    }

    public void removeSessionObject(Class aClass) {
        if (this.hasSession() && aClass != null) {
            this.getSession().removeAttribute(aClass.getName());
        }
    }

    public boolean hasSession() {
        return this.request.getSession(false) != null;
    }

    public Page createPage(String path) {
        return this.pageMaker.createPage(path);
    }

    public Locale getLocale() {
        Locale locale = (Locale)this.getSessionAttribute(LOCALE);
        if (locale == null) {
            locale = this.getRequest().getLocale();
        }
        return locale;
    }

    public void setLocale(Locale locale) {
        if (locale == null && this.hasSession()) {
            this.getSession().removeAttribute(LOCALE);
        } else {
            this.setSessionAttribute(LOCALE, locale);
        }
    }

    public Map getMultiPartFormData() {
        if (this.multiPartFormData != null) {
            return this.multiPartFormData;
        }
        return Collections.EMPTY_MAP;
    }

    public void setMultiPartFormData(Map multiPartFormData) {
        if (!this.isMultipartRequest()) {
            String msg = "Not a POST Content-type 'multipart' request";
            throw new IllegalStateException(msg);
        }
        this.multiPartFormData = multiPartFormData;
    }

    public boolean isMultipartRequest() {
        return this.isPost() && FileUploadBase.isMultipartContent((HttpServletRequest)this.request);
    }
}

