/*
 * Decompiled with CFR 0.152.
 */
package net.sf.click;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.click.ClickApp;
import net.sf.click.Context;
import net.sf.click.Control;
import net.sf.click.Page;
import net.sf.click.util.ClickLogger;
import net.sf.click.util.ClickUtils;
import net.sf.click.util.ErrorPage;
import net.sf.click.util.ErrorReport;
import net.sf.click.util.MessagesMap;
import net.sf.click.util.SessionMap;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.io.VelocityWriter;
import org.apache.velocity.util.SimplePool;

public class ClickServlet
extends HttpServlet {
    private static final long serialVersionUID = 3835158375989262128L;
    private static final String APPLICAION_RELOADED_MSG = "<html><head><style type='text/css'>body{font-family:Arial;}</style></head><body><h2>Application Reloaded</h2></body></html>";
    protected static final String CLICK_FORWARD = "click-forward";
    protected static final String APP_RELOADABLE = "app-reloadable";
    protected static final String FORWARD_PAGE = "forward-page";
    protected ClickApp clickApp;
    protected ClickLogger logger;
    protected final PageMaker pageMaker = new PageMaker();
    protected boolean reloadable = false;
    protected SimplePool writerPool;

    public void init() throws ServletException {
        try {
            this.clickApp = null;
            this.writerPool = null;
            this.reloadable = "true".equalsIgnoreCase(this.getInitParameter(APP_RELOADABLE));
            ClickApp newClickApp = new ClickApp();
            newClickApp.init(this.getServletContext());
            this.logger = newClickApp.getLogger();
            SimplePool newWriterPool = new SimplePool(40);
            this.clickApp = newClickApp;
            this.writerPool = newWriterPool;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("initialized in " + this.clickApp.getModeValue() + " mode");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            String message = "error initializing throwing javax.servlet.UnavailableException";
            this.log(message, e);
            throw new UnavailableException(e.toString());
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.ensureAppInitialized();
        if (this.ifAuthorizedReloadRequest(request)) {
            this.reloadClickApp(request, response);
        } else {
            this.handleRequest(request, response, false);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.ensureAppInitialized();
        this.handleRequest(request, response, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequest(HttpServletRequest request, HttpServletResponse response, boolean isPost) {
        block17: {
            long startTime = System.currentTimeMillis();
            if (this.logger.isDebugEnabled()) {
                StringBuffer buffer = new StringBuffer(200);
                buffer.append(request.getMethod());
                buffer.append(" ");
                buffer.append(request.getRequestURL());
                this.logger.debug(buffer);
            }
            if (this.logger.isTraceEnabled()) {
                TreeMap<String, String> requestParams = new TreeMap<String, String>();
                Enumeration paramNames = request.getParameterNames();
                while (paramNames.hasMoreElements()) {
                    String name = paramNames.nextElement().toString();
                    requestParams.put(name, request.getParameter(name));
                }
                Iterator i = requestParams.keySet().iterator();
                while (i.hasNext()) {
                    String name = i.next().toString();
                    String value = requestParams.get(name).toString();
                    this.logger.trace("   " + name + "=" + value);
                }
            }
            Page page = null;
            try {
                try {
                    page = this.createPage(request, response, isPost);
                    this.processPage(page);
                }
                catch (Exception e) {
                    this.handleException(request, response, isPost, e, page);
                    Object var12_13 = null;
                    if (page != null) {
                        page.onDestroy();
                    }
                    if (!this.clickApp.isProductionMode()) {
                        this.logger.info("handleRequest:  " + page.getPath() + " - " + (System.currentTimeMillis() - startTime) + " ms");
                    }
                    break block17;
                }
                catch (ExceptionInInitializerError eiie) {
                    Throwable cause = eiie.getException();
                    cause = cause != null ? cause : eiie;
                    this.handleException(request, response, isPost, cause, page);
                    Object var12_14 = null;
                    if (page != null) {
                        page.onDestroy();
                    }
                    if (!this.clickApp.isProductionMode()) {
                        this.logger.info("handleRequest:  " + page.getPath() + " - " + (System.currentTimeMillis() - startTime) + " ms");
                    }
                }
                Object var12_12 = null;
                if (page != null) {
                    page.onDestroy();
                }
                if (!this.clickApp.isProductionMode()) {
                    this.logger.info("handleRequest:  " + page.getPath() + " - " + (System.currentTimeMillis() - startTime) + " ms");
                }
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                if (page != null) {
                    page.onDestroy();
                }
                if (!this.clickApp.isProductionMode()) {
                    this.logger.info("handleRequest:  " + page.getPath() + " - " + (System.currentTimeMillis() - startTime) + " ms");
                }
                throw throwable;
            }
        }
    }

    protected void handleException(HttpServletRequest request, HttpServletResponse response, boolean isPost, Throwable exception, Page page) {
        if (!(exception instanceof ParseErrorException)) {
            this.logger.error("handleException: ", exception);
        }
        Context context = new Context(this.getServletContext(), this.getServletConfig(), request, response, isPost, this.pageMaker);
        ErrorPage errorPage = null;
        try {
            errorPage = (ErrorPage)this.clickApp.getErrorPageClass().newInstance();
            errorPage.setContext(context);
            errorPage.setError(exception);
            errorPage.setFormat(this.clickApp.getPageFormat("click/error.htm"));
            errorPage.setHeaders(this.clickApp.getPageHeaders("click/error.htm"));
            errorPage.setMode(this.clickApp.getModeValue());
            errorPage.setPage(page);
            errorPage.setPath("click/error.htm");
            this.processPage(errorPage);
        }
        catch (Exception ex) {
            String message = "handleError: " + ex.getClass().getName() + " thrown while handling " + exception.getClass().getName() + ". Now throwing RuntimeException.";
            this.logger.error(message, ex);
            throw new RuntimeException(ex);
        }
        finally {
            if (errorPage != null) {
                errorPage.onDestroy();
            }
        }
    }

    protected void processPage(Page page) throws Exception {
        HttpServletRequest request = page.getContext().getRequest();
        HttpServletResponse response = page.getContext().getResponse();
        boolean isPost = page.getContext().isPost();
        page.onInit();
        boolean continueProcessing = page.onSecurityCheck();
        if (continueProcessing && page.hasControls() && !page.getContext().isForward()) {
            Control control;
            List controls = page.getControls();
            int size = controls.size();
            for (int i = 0; i < size && (continueProcessing = (control = (Control)controls.get(i)).onProcess()); ++i) {
            }
        }
        if (continueProcessing) {
            if (isPost) {
                page.onPost();
            } else {
                page.onGet();
            }
        }
        if (page.getRedirect() != null) {
            String url = response.encodeRedirectURL(page.getRedirect());
            if (url.charAt(0) == '/') {
                url = request.getContextPath() + url;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("redirect=" + url);
            }
            response.sendRedirect(url);
        } else if (page.getForward() != null) {
            request.setAttribute(CLICK_FORWARD, (Object)CLICK_FORWARD);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("forward=" + page.getForward());
            }
            RequestDispatcher dispatcher = request.getRequestDispatcher(page.getForward());
            if (page.getForward().endsWith(".jsp")) {
                this.setRequestAttributes(page);
            }
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        } else if (page.getPath() != null) {
            this.renderTemplate(page);
        } else {
            String msg = "Path not defined for Page " + page.getClass().getName();
            throw new RuntimeException(msg);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void renderTemplate(Page page) throws Exception {
        long startTime = System.currentTimeMillis();
        VelocityContext context = this.createVelocityContext(page);
        Template template = this.clickApp.getTemplate(page.getTemplate());
        HttpServletResponse response = page.getContext().getResponse();
        response.setContentType(page.getContentType());
        ServletOutputStream output = response.getOutputStream();
        if (page.getHeaders() != null) {
            this.setPageResponseHeaders(response, page.getHeaders());
        }
        String encoding = response.getCharacterEncoding();
        VelocityWriter velocityWriter = null;
        try {
            try {
                velocityWriter = (VelocityWriter)this.writerPool.get();
                if (velocityWriter == null) {
                    velocityWriter = new VelocityWriter((Writer)new OutputStreamWriter((OutputStream)output, encoding), 4096, true);
                } else {
                    velocityWriter.recycle((Writer)new OutputStreamWriter((OutputStream)output, encoding));
                }
                template.merge((org.apache.velocity.context.Context)context, (Writer)velocityWriter);
            }
            catch (Exception error) {
                ErrorReport errorReport = new ErrorReport(error, page, this.clickApp.isProductionMode());
                velocityWriter.write(errorReport.getErrorReport());
                throw error;
            }
            Object var13_9 = null;
            {
            }
        }
        catch (Throwable throwable) {
            Object var13_10 = null;
            try {
                if (velocityWriter != null) {
                    velocityWriter.flush();
                    velocityWriter.recycle(null);
                    this.writerPool.put((Object)velocityWriter);
                }
                if (output == null) throw throwable;
                output.flush();
                output.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        if (velocityWriter != null) {
            velocityWriter.flush();
            velocityWriter.recycle(null);
            this.writerPool.put((Object)velocityWriter);
        }
        if (output != null) {
            output.flush();
            output.close();
        }
        if (this.clickApp.isProductionMode()) return;
        StringBuffer buffer = new StringBuffer(50);
        buffer.append("renderTemplate: ");
        if (!page.getTemplate().equals(page.getPath())) {
            buffer.append(page.getPath());
            buffer.append(",");
        }
        buffer.append(page.getTemplate());
        buffer.append(" - ");
        buffer.append(System.currentTimeMillis() - startTime);
        buffer.append(" ms");
        this.logger.info(buffer);
    }

    protected Page createPage(HttpServletRequest request, HttpServletResponse response, boolean isPost) {
        Context context = new Context(this.getServletContext(), this.getServletConfig(), request, response, isPost, this.pageMaker);
        String path = context.getResourcePath();
        if (request.getAttribute(FORWARD_PAGE) != null) {
            Page forwardPage = (Page)request.getAttribute(FORWARD_PAGE);
            forwardPage.setContext(context);
            request.removeAttribute(FORWARD_PAGE);
            return forwardPage;
        }
        Class pageClass = this.clickApp.getPageClass(path);
        if (pageClass == null) {
            pageClass = this.clickApp.getNotFoundPageClass();
            path = "click/not-found.htm";
        }
        try {
            Page newPage = this.newPageInstance(path, pageClass);
            newPage.setContext(context);
            newPage.setFormat(this.clickApp.getPageFormat(path));
            newPage.setHeaders(this.clickApp.getPageHeaders(path));
            newPage.setPath(path);
            return newPage;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Page newPageInstance(String path, Class pageClass) throws Exception {
        return (Page)pageClass.newInstance();
    }

    protected VelocityContext createVelocityContext(Page page) {
        MessagesMap messagesMap;
        String path;
        Object format;
        String msg;
        SessionMap sessionMap;
        String msg2;
        HttpServletRequest request;
        VelocityContext context = new VelocityContext(page.getModel());
        Object pop = context.put("request", (Object)(request = page.getContext().getRequest()));
        if (pop != null) {
            msg2 = page.getClass().getName() + " on " + page.getPath() + " model contains an object keyed with reserved " + "name \"request\". The page model object " + pop + " has been replaced with the request object";
            this.logger.warn(msg2);
        }
        if ((pop = context.put("response", (Object)page.getContext().getResponse())) != null) {
            msg2 = page.getClass().getName() + " on " + page.getPath() + " model contains an object keyed with reserved " + "name \"response\". The page model object " + pop + " has been replaced with the response object";
            this.logger.warn(msg2);
        }
        if ((pop = context.put("session", (Object)(sessionMap = new SessionMap(request.getSession(false))))) != null) {
            msg = page.getClass().getName() + " on " + page.getPath() + " model contains an object keyed with reserved " + "name \"session\". The page model object " + pop + " has been replaced with the request " + " session";
            this.logger.warn(msg);
        }
        if ((pop = context.put("context", (Object)request.getContextPath())) != null) {
            msg = page.getClass().getName() + " on " + page.getPath() + " model contains an object keyed with reserved " + "name \"context\". The page model object " + pop + " has been replaced with the request " + " context path";
            this.logger.warn(msg);
        }
        if ((format = page.getFormat()) != null && (pop = context.put("format", format)) != null) {
            String msg3 = page.getClass().getName() + " on " + page.getPath() + " model contains an object keyed with reserved " + "name \"format\". The page model object " + pop + " has been replaced with the format object";
            this.logger.warn(msg3);
        }
        if ((path = page.getPath()) != null && (pop = context.put("path", (Object)path)) != null) {
            String msg4 = page.getClass().getName() + " on " + page.getPath() + " model contains an object keyed with reserved " + "name \"path\". The page model object " + pop + " has been replaced with the page path";
            this.logger.warn(msg4);
        }
        if ((pop = context.put("messages", (Object)(messagesMap = new MessagesMap(page)))) != null) {
            String msg5 = page.getClass().getName() + " on " + page.getPath() + " model contains an object keyed with reserved " + "name \"messages\". The page model object " + pop + " has been replaced with the request " + " messages";
            this.logger.warn(msg5);
        }
        return context;
    }

    protected void setPageResponseHeaders(HttpServletResponse response, Map headers) {
        Iterator headerNames = headers.keySet().iterator();
        while (headerNames.hasNext()) {
            String name = headerNames.next().toString();
            Object value = headers.get(name);
            if (value instanceof String) {
                String strValue = (String)value;
                if (strValue.equalsIgnoreCase("Content-Encoding")) continue;
                response.setHeader(name, strValue);
                continue;
            }
            if (value instanceof Date) {
                long time = ((Date)value).getTime();
                response.setDateHeader(name, time);
                continue;
            }
            int intValue = (Integer)value;
            response.setIntHeader(name, intValue);
        }
    }

    protected void ensureAppInitialized() throws UnavailableException {
        if (this.clickApp == null || this.writerPool == null) {
            if (this.reloadable) {
                String msg = "The application is temporarily unavailable - please try again in 1 minute";
                throw new UnavailableException(msg, 60);
            }
            String msg = "The application is unavailable.";
            throw new UnavailableException(msg);
        }
    }

    protected boolean ifAuthorizedReloadRequest(HttpServletRequest request) {
        if (this.reloadable && request.isUserInRole("click-admin")) {
            String path = ClickUtils.getResourcePath(request);
            return "/click/reload-app.htm".equals(path);
        }
        return false;
    }

    protected void reloadClickApp(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.init();
        String msg = "ClickApp reloaded by " + request.getRemoteUser() + " on " + new Date().toString();
        this.logger.info(msg);
        response.setContentType("text/html");
        response.getWriter().print(APPLICAION_RELOADED_MSG);
        response.getWriter().close();
    }

    protected void setRequestAttributes(Page page) {
        String path;
        HttpServletRequest request = page.getContext().getRequest();
        Map model = page.getModel();
        Iterator i = model.keySet().iterator();
        while (i.hasNext()) {
            String name = i.next().toString();
            request.setAttribute(name, model.get(name));
        }
        request.setAttribute("context", (Object)request.getContextPath());
        Object format = page.getFormat();
        if (format != null) {
            request.setAttribute("format", format);
        }
        if ((path = page.getPath()) != null) {
            request.setAttribute("path", (Object)path);
        }
        MessagesMap messagesMap = new MessagesMap(page);
        request.setAttribute("messages", (Object)messagesMap);
    }

    class PageMaker {
        PageMaker() {
        }

        Page createPage(String path) {
            Class pageClass = ClickServlet.this.clickApp.getPageClass(path);
            if (pageClass == null) {
                String msg = "No Page class configured for path: " + path;
                throw new IllegalArgumentException(msg);
            }
            try {
                Page newPage = ClickServlet.this.newPageInstance(path, pageClass);
                newPage.setFormat(ClickServlet.this.clickApp.getPageFormat(path));
                newPage.setHeaders(ClickServlet.this.clickApp.getPageHeaders(path));
                newPage.setPath(path);
                return newPage;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

