/*
 * Decompiled with CFR 0.152.
 */
package net.sf.click;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import net.sf.click.util.ClickLogger;
import net.sf.click.util.ClickUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.ParseErrorException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class ClickApp
implements EntityResolver {
    static final String DEFAULT_APP_CONFIG = "/WEB-INF/click.xml";
    static final String DEFAULT_VEL_PROPS = "/WEB-INF/velocity.properties";
    static final String CLICK_LOGGER = "net.sf.click";
    static final String VELOCITY_LOGGER = "org.apache.velocity";
    static final String CLICK_PATH = "click";
    static final String DTD_FILE_NAME = "click.dtd";
    static final String DTD_FILE_PATH = "/net/sf/click/click.dtd";
    static final String ERROR_FILE_NAME = "error.htm";
    static final String ERROR_PATH = "click/error.htm";
    static final String NOT_FOUND_FILE_NAME = "not-found.htm";
    static final String NOT_FOUND_PATH = "click/not-found.htm";
    static final String VM_FILE_NAME = "VM_global_library.vm";
    static final String MACRO_VM_FILE_NAME = "macro.vm";
    static final int PRODUCTION = 0;
    static final int PROFILE = 1;
    static final int DEVELOPMENT = 2;
    static final int DEBUG = 3;
    static final int TRACE = 4;
    static final String[] MODE_VALUES = new String[]{"production", "profile", "development", "debug", "trace"};
    private static final Object PAGE_LOAD_LOCK = new Object();
    private Class formatClass;
    private Map commonHeaders;
    private ClickLogger logger;
    private int mode;
    private final Map pageByPathMap = new HashMap();
    private String pagesPackage;
    private ServletContext servletContext;
    private final VelocityEngine velocityEngine = new VelocityEngine();
    static /* synthetic */ Class class$javax$servlet$ServletContext;
    static /* synthetic */ Class class$net$sf$click$Page;
    static /* synthetic */ Class class$net$sf$click$util$ErrorPage;
    static /* synthetic */ Class class$net$sf$click$util$Format;
    static /* synthetic */ Class class$org$apache$velocity$tools$view$servlet$WebappLoader;
    static /* synthetic */ Class class$net$sf$click$util$ClickLogger;

    ClickApp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(ServletContext context) throws Exception {
        this.servletContext = context;
        this.logger = new ClickLogger("Click");
        InputStream inputStream = this.servletContext.getResourceAsStream(DEFAULT_APP_CONFIG);
        if (inputStream == null) {
            throw new RuntimeException("could not find click app configuration file: /WEB-INF/click.xml");
        }
        try {
            Document document = ClickUtils.buildDocument(inputStream, this);
            Element rootElm = document.getDocumentElement();
            this.loadMode(rootElm);
            this.loadFormatClass(rootElm);
            this.loadPages(rootElm);
            this.loadDefaultPages();
            this.deployFiles();
            this.velocityEngine.setApplicationAttribute((Object)(class$javax$servlet$ServletContext == null ? (class$javax$servlet$ServletContext = ClickApp.class$("javax.servlet.ServletContext")) : class$javax$servlet$ServletContext).getName(), (Object)this.servletContext);
            Properties properties = this.getVelocityProperties(this.servletContext);
            this.velocityEngine.init(properties);
            if (this.mode == 3 || this.mode == 4) {
                ClickLogger logger = ClickLogger.getInstance(this.velocityEngine);
                logger.setLevel(2);
            }
            this.loadTemplates();
        }
        finally {
            ClickUtils.close(inputStream);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputStream inputStream = this.getClass().getResourceAsStream(DTD_FILE_PATH);
        if (inputStream != null) {
            return new InputSource(inputStream);
        }
        throw new IOException("could not load resource: /net/sf/click/click.dtd");
    }

    ClickLogger getLogger() {
        return this.logger;
    }

    boolean isProductionMode() {
        return this.mode == 0;
    }

    String getModeValue() {
        return MODE_VALUES[this.mode];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class getPageClass(String path) {
        if (this.mode <= 1) {
            PageElm page = (PageElm)this.pageByPathMap.get(path);
            if (page != null) {
                return page.getPageClass();
            }
            return null;
        }
        Object object = PAGE_LOAD_LOCK;
        synchronized (object) {
            PageElm page = (PageElm)this.pageByPathMap.get(path);
            if (page != null) {
                return page.getPageClass();
            }
            Class pageClass = null;
            if (this.servletContext.getResourcePaths(path) != null && (pageClass = this.getPageClass(path, this.pagesPackage)) != null) {
                page = new PageElm(path, pageClass, this.commonHeaders, this.formatClass);
                this.pageByPathMap.put(page.getPath(), page);
                if (this.logger.isDebugEnabled()) {
                    String msg = path + " -> " + pageClass.getName();
                    this.logger.debug(msg);
                }
            }
            return pageClass;
        }
    }

    Object getPageFormat(String path) {
        PageElm page = (PageElm)this.pageByPathMap.get(path);
        if (page != null) {
            try {
                return page.getFormatClass().newInstance();
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae);
            }
            catch (InstantiationException ie) {
                throw new RuntimeException(ie);
            }
        }
        return null;
    }

    Map getPageHeaders(String path) {
        PageElm page = (PageElm)this.pageByPathMap.get(path);
        if (page != null) {
            return page.getHeaders();
        }
        return null;
    }

    Class getNotFoundPageClass() {
        PageElm page = (PageElm)this.pageByPathMap.get(NOT_FOUND_PATH);
        if (page != null) {
            return page.getPageClass();
        }
        return class$net$sf$click$Page == null ? (class$net$sf$click$Page = ClickApp.class$("net.sf.click.Page")) : class$net$sf$click$Page;
    }

    Class getErrorPageClass() {
        PageElm page = (PageElm)this.pageByPathMap.get(ERROR_PATH);
        if (page != null) {
            return page.getPageClass();
        }
        return class$net$sf$click$util$ErrorPage == null ? (class$net$sf$click$util$ErrorPage = ClickApp.class$("net.sf.click.util.ErrorPage")) : class$net$sf$click$util$ErrorPage;
    }

    Template getTemplate(String path) throws Exception {
        return this.velocityEngine.getTemplate(path);
    }

    private void deployFiles() {
        block8: {
            String path = this.servletContext.getRealPath("/");
            if (path != null) {
                String clickTarget = path + File.separator + CLICK_PATH;
                File clickDir = new File(clickTarget);
                if (!clickDir.exists() && !clickDir.mkdir()) {
                    this.logger.error("could not create deployment directory: " + clickDir);
                }
                this.deployFile("/net/sf/click/control/calendar.gif", clickTarget, CLICK_PATH, "calendar.gif");
                this.deployFile("/net/sf/click/control/calendar-en.js", clickTarget, CLICK_PATH, "calendar-en.js");
                this.deployFile("/net/sf/click/control/control.css", clickTarget, CLICK_PATH, "control.css");
                this.deployFile("/net/sf/click/control/control.js", clickTarget, CLICK_PATH, "control.js");
                this.deployFile("/net/sf/click/util/error.htm", clickTarget, CLICK_PATH, ERROR_FILE_NAME);
                this.deployFile("/net/sf/click/not-found.htm", clickTarget, CLICK_PATH, NOT_FOUND_FILE_NAME);
                this.deployFile("/net/sf/click/control/VM_global_library.vm", clickTarget, CLICK_PATH, VM_FILE_NAME);
                try {
                    ResourceBundle bundle = ResourceBundle.getBundle("click-deploy");
                    String filenames = bundle.getString("click.deploy.files");
                    if (filenames != null) {
                        StringTokenizer tokens = new StringTokenizer(filenames, ",");
                        while (tokens.hasMoreTokens()) {
                            String key = "click.deploy.path." + tokens.nextToken();
                            String filepath = bundle.getString(key);
                            if (filepath != null) {
                                String filename = filepath.substring(filepath.lastIndexOf(47) + 1);
                                this.deployFile(filepath, clickTarget, CLICK_PATH, filename);
                                continue;
                            }
                            this.logger.warn("Could not find property: " + key);
                        }
                        break block8;
                    }
                    this.logger.warn("could not load /click-deploy.properties");
                }
                catch (MissingResourceException mre) {
                    this.logger.info("/click-deploy.properties file not found");
                }
            } else {
                this.logger.error("Servlet real path is null. Could not deploy files");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void deployFile(String resource, String path, String dir, String filename) {
        block21: {
            block22: {
                IOException ioe222;
                FileOutputStream fos;
                InputStream inputStream;
                String destination;
                block19: {
                    block18: {
                        int length;
                        destination = path;
                        destination = path.endsWith(File.separator) || filename.startsWith(File.separator) ? destination + filename : destination + File.separator + File.separator + filename;
                        File destinationFile = new File(destination);
                        if (destinationFile.exists()) break block21;
                        inputStream = this.getClass().getResourceAsStream(resource);
                        if (inputStream == null) break block22;
                        fos = null;
                        fos = new FileOutputStream(destinationFile);
                        byte[] buffer = new byte[1024];
                        while ((length = inputStream.read(buffer)) >= 0) {
                            fos.write(buffer, 0, length);
                        }
                        if (!this.logger.isTraceEnabled()) break block18;
                        this.logger.trace("deployed " + dir + File.separator + filename);
                    }
                    Object var12_12 = null;
                    if (fos == null) break block19;
                    try {
                        fos.close();
                    }
                    catch (IOException ioe222) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ioe222) {}
                }
                break block21;
                {
                    catch (IOException ioe3) {
                        IOException ioe222;
                        this.logger.error("could not deploy " + destination, ioe3);
                        Object var12_13 = null;
                        if (fos != null) {
                            try {
                                fos.close();
                            }
                            catch (IOException ioe222) {
                                // empty catch block
                            }
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException ioe222) {}
                        }
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    IOException ioe222;
                    Object var12_14 = null;
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException ioe222) {
                            // empty catch block
                        }
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException ioe222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            this.logger.warn("could not locate classpath resource: " + resource);
        }
    }

    private void loadMode(Element rootElm) {
        Element modeElm = this.getChild(rootElm, "mode");
        String logto = "console";
        if (modeElm != null) {
            String modeValue = modeElm.getAttribute("value");
            if (modeValue.equalsIgnoreCase("production")) {
                this.mode = 0;
            } else if (modeValue.equalsIgnoreCase("profile")) {
                this.mode = 1;
            } else if (modeValue.equalsIgnoreCase("development")) {
                this.mode = 2;
            } else if (modeValue.equalsIgnoreCase("debug")) {
                this.mode = 3;
            } else if (modeValue.equalsIgnoreCase("trace")) {
                this.mode = 4;
            } else {
                this.logger.error("invalid application mode: " + this.mode);
                this.mode = 3;
            }
            logto = modeElm.getAttribute("logto");
            if (StringUtils.isBlank((String)logto)) {
                logto = "console";
            }
        } else {
            this.mode = 2;
        }
        int clickLogLevel = 1;
        Integer velocityLogLevel = new Integer(3);
        if (this.mode == 0) {
            clickLogLevel = 2;
        } else if (this.mode == 2) {
            velocityLogLevel = new Integer(2);
        } else if (this.mode == 3) {
            clickLogLevel = 0;
            velocityLogLevel = new Integer(2);
        } else if (this.mode == 4) {
            clickLogLevel = -1;
            velocityLogLevel = new Integer(1);
        }
        this.logger.setLevel(clickLogLevel);
        this.velocityEngine.setApplicationAttribute((Object)ClickLogger.LOG_LEVEL, (Object)velocityLogLevel);
        if (logto.equalsIgnoreCase("servlet")) {
            this.logger.setServletContext(this.servletContext);
            this.velocityEngine.setApplicationAttribute((Object)ClickLogger.LOG_TO, (Object)"servlet");
        } else if (!logto.equalsIgnoreCase("console")) {
            String msg = "Invalid mode logto attribute '" + logto + "' logging to console instead.";
            this.logger.warn(msg);
        }
    }

    private void loadDefaultPages() throws ClassNotFoundException {
        PageElm page;
        if (!this.pageByPathMap.containsKey(ERROR_PATH)) {
            page = new PageElm("net.sf.click.util.ErrorPage", ERROR_PATH, this.formatClass);
            this.pageByPathMap.put(ERROR_PATH, page);
        }
        if (!this.pageByPathMap.containsKey(NOT_FOUND_PATH)) {
            page = new PageElm("net.sf.click.Page", NOT_FOUND_PATH, this.formatClass);
            this.pageByPathMap.put(NOT_FOUND_PATH, page);
        }
    }

    private void loadFormatClass(Element rootElm) throws ClassNotFoundException {
        Element formatElm = this.getChild(rootElm, "format");
        if (formatElm != null) {
            String classname = formatElm.getAttribute("classname");
            if (classname == null) {
                throw new RuntimeException("'format' element missing 'classname' attribute.");
            }
            this.formatClass = Class.forName(classname);
        } else {
            this.formatClass = class$net$sf$click$util$Format == null ? (class$net$sf$click$util$Format = ClickApp.class$("net.sf.click.util.Format")) : class$net$sf$click$util$Format;
        }
    }

    private void loadTemplates() throws Exception {
        if (this.mode == 0 || this.mode == 1) {
            Iterator i = this.pageByPathMap.keySet().iterator();
            while (i.hasNext()) {
                String path = i.next().toString();
                try {
                    this.getTemplate(path);
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("loaded page template " + path);
                }
                catch (ParseErrorException pee) {
                    this.logger.warn("Errors in page '" + path, pee);
                }
            }
        }
    }

    private void loadPages(Element rootElm) throws ClassNotFoundException {
        Element pagesElm = this.getChild(rootElm, "pages");
        if (pagesElm == null) {
            throw new RuntimeException("required configuration 'pages' element missing.");
        }
        this.pagesPackage = pagesElm.getAttribute("package");
        if (StringUtils.isBlank((String)this.pagesPackage)) {
            this.pagesPackage = "";
        }
        this.pagesPackage = this.pagesPackage.trim();
        if (this.pagesPackage.endsWith(".")) {
            this.pagesPackage = this.pagesPackage.substring(0, this.pagesPackage.length() - 2);
        }
        boolean automap = false;
        String automapStr = pagesElm.getAttribute("automapping");
        if (StringUtils.isBlank((String)automapStr)) {
            automapStr = "false";
        }
        if ("true".equalsIgnoreCase(automapStr)) {
            automap = true;
        } else if ("false".equalsIgnoreCase(automapStr)) {
            automap = false;
        } else {
            String msg = "Invalid pages automap attribute: " + automapStr;
            throw new RuntimeException(msg);
        }
        Element headersElm = this.getChild(rootElm, "headers");
        this.commonHeaders = headersElm != null ? Collections.unmodifiableMap(ClickApp.loadHeadersMap(headersElm)) : Collections.EMPTY_MAP;
        List pageList = ClickApp.getChildren(pagesElm, "page");
        if (!pageList.isEmpty() && this.logger.isDebugEnabled()) {
            this.logger.debug("click.xml pages:");
        }
        for (int i = 0; i < pageList.size(); ++i) {
            Element pageElm = (Element)pageList.get(i);
            PageElm page = new PageElm(pageElm, this.pagesPackage, this.commonHeaders, this.formatClass);
            this.pageByPathMap.put(page.getPath(), page);
            if (!this.logger.isDebugEnabled()) continue;
            String msg = page.getPath() + " -> " + page.getPageClass().getName();
            this.logger.debug(msg);
        }
        if (automap) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("automapped pages:");
            }
            List templates = this.getTemplateFiles();
            for (int i = 0; i < templates.size(); ++i) {
                Class pageClass;
                String pagePath = (String)templates.get(i);
                if (this.pageByPathMap.containsKey(pagePath) || (pageClass = this.getPageClass(pagePath, this.pagesPackage)) == null) continue;
                PageElm page = new PageElm(pagePath, pageClass, this.commonHeaders, this.formatClass);
                this.pageByPathMap.put(page.getPath(), page);
                if (!this.logger.isDebugEnabled()) continue;
                String msg = pagePath + " -> " + pageClass.getName();
                this.logger.debug(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getVelocityProperties(ServletContext context) throws Exception {
        Properties velProps = new Properties();
        velProps.setProperty("resource.loader", "webapp");
        velProps.setProperty("webapp.resource.loader.class", (class$org$apache$velocity$tools$view$servlet$WebappLoader == null ? (class$org$apache$velocity$tools$view$servlet$WebappLoader = ClickApp.class$("org.apache.velocity.tools.view.servlet.WebappLoader")) : class$org$apache$velocity$tools$view$servlet$WebappLoader).getName());
        if (this.mode == 0 || this.mode == 1) {
            velProps.put("webapp.resource.loader.cache", "true");
            velProps.put("webapp.resource.loader.modificationCheckInterval", "0");
            velProps.put("velocimacro.library.autoreload", "false");
        } else {
            velProps.put("webapp.resource.loader.cache", "false");
            velProps.put("velocimacro.library.autoreload", "true");
        }
        velProps.put("runtime.log.logsystem.class", (class$net$sf$click$util$ClickLogger == null ? (class$net$sf$click$util$ClickLogger = ClickApp.class$("net.sf.click.util.ClickLogger")) : class$net$sf$click$util$ClickLogger).getName());
        String macroPath = context.getRealPath("/macro.vm");
        if (macroPath != null) {
            File file = new File(macroPath);
            if (file.canRead() && file.isFile()) {
                velProps.put("velocimacro.library", MACRO_VM_FILE_NAME);
            } else {
                velProps.put("velocimacro.library", CLICK_PATH + File.separator + VM_FILE_NAME);
            }
        } else {
            velProps.put("velocimacro.library", CLICK_PATH + File.separator + VM_FILE_NAME);
        }
        Properties userProperties = new Properties();
        String filename = DEFAULT_VEL_PROPS;
        InputStream inputStream = context.getResourceAsStream(filename);
        if (inputStream != null) {
            try {
                userProperties.load(inputStream);
            }
            catch (IOException ioe) {
                String message = "error loading velocity properties file: " + filename;
                this.logger.error(message, ioe);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException ioe) {}
            }
        }
        Iterator<Map.Entry<Object, Object>> iterator = userProperties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            Object pop = velProps.put(entry.getKey(), entry.getValue());
            if (pop == null || !this.logger.isDebugEnabled()) continue;
            String message = "user defined property '" + entry.getKey() + "=" + entry.getValue() + "' replaced default propery '" + entry.getKey() + "=" + pop + "'";
            this.logger.debug(message);
        }
        if (this.logger.isTraceEnabled()) {
            TreeMap<Object, Object> sortedPropMap = new TreeMap<Object, Object>();
            Iterator<Map.Entry<Object, Object>> i = velProps.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<Object, Object> entry = i.next();
                sortedPropMap.put(entry.getKey(), entry.getValue());
            }
            this.logger.trace("velocity properties: " + sortedPropMap);
        }
        return velProps;
    }

    private static Map loadHeadersMap(Element parentElm) {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        List headerList = ClickApp.getChildren(parentElm, "header");
        int size = headerList.size();
        for (int i = 0; i < size; ++i) {
            Element header = (Element)headerList.get(i);
            String name = header.getAttribute("name");
            String type = header.getAttribute("type");
            String propertyValue = header.getAttribute("value");
            Object value = null;
            if ("".equals(type) || "String".equalsIgnoreCase(type)) {
                value = propertyValue;
            } else if ("Integer".equalsIgnoreCase(type)) {
                value = Integer.valueOf(propertyValue);
            } else if ("Date".equalsIgnoreCase(type)) {
                value = new Date(Long.parseLong(propertyValue));
            } else {
                value = null;
                String message = "Invalid property type [String|Integer|Date]: " + type;
                throw new IllegalArgumentException(message);
            }
            headersMap.put(name, (String)value);
        }
        return headersMap;
    }

    private List getTemplateFiles() {
        ArrayList<String> fileList = new ArrayList<String>();
        Set resources = this.servletContext.getResourcePaths("/");
        Iterator i = resources.iterator();
        while (i.hasNext()) {
            String resource = (String)i.next();
            if (resource.endsWith(".htm")) {
                fileList.add(resource);
                continue;
            }
            if (!resource.endsWith("/") || resource.equals("/click/") || resource.equalsIgnoreCase("/WEB-INF/")) continue;
            this.processDirectory(resource, fileList);
        }
        return fileList;
    }

    private void processDirectory(String dirPath, List fileList) {
        Set resources = this.servletContext.getResourcePaths(dirPath);
        Iterator i = resources.iterator();
        while (i.hasNext()) {
            String resource = (String)i.next();
            if (resource.endsWith(".htm")) {
                fileList.add(resource);
                continue;
            }
            if (!resource.endsWith("/")) continue;
            this.processDirectory(resource, fileList);
        }
    }

    private Class getPageClass(String pagePath, String pagesPackage) {
        Class<?> pageClass;
        block9: {
            String token;
            StringTokenizer tokenizer;
            String packageName = pagesPackage + ".";
            String className = "";
            String path = pagePath.substring(0, pagePath.lastIndexOf("."));
            if (path.indexOf("/") != -1) {
                tokenizer = new StringTokenizer(path, "/");
                while (tokenizer.hasMoreTokens()) {
                    token = tokenizer.nextToken();
                    if (tokenizer.hasMoreTokens()) {
                        packageName = packageName + token + ".";
                        continue;
                    }
                    className = token;
                }
            } else {
                className = path;
            }
            tokenizer = new StringTokenizer(className, "_-");
            className = "";
            while (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken();
                token = Character.toUpperCase(token.charAt(0)) + token.substring(1);
                className = className + token;
            }
            className = packageName + className;
            pageClass = null;
            try {
                pageClass = Class.forName(className);
                if (!(class$net$sf$click$Page == null ? (class$net$sf$click$Page = ClickApp.class$("net.sf.click.Page")) : class$net$sf$click$Page).isAssignableFrom(pageClass)) {
                    String msg = "Automapped page class " + className + " is not a subclass of net.sf.clic.Page";
                    throw new RuntimeException(msg);
                }
            }
            catch (ClassNotFoundException cnfe) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(pagePath + " -> CLASS NOT FOUND");
                }
                if (!this.logger.isTraceEnabled()) break block9;
                this.logger.trace("class not found: " + className);
            }
        }
        return pageClass;
    }

    private Element getChild(Element element, String name) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals(name)) continue;
            return (Element)node;
        }
        return null;
    }

    private static List getChildren(Element element, String name) {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals(name)) continue;
            list.add(node);
        }
        return list;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PageElm {
        private final Class formatClass;
        private final Map headers;
        private final Class pageClass;
        private final String path;

        private PageElm(Element element, String pagesPackage, Map commonHeaders, Class formatClass) throws ClassNotFoundException {
            this.formatClass = formatClass;
            HashMap aggregationMap = new HashMap(commonHeaders);
            Map pageHeaders = ClickApp.loadHeadersMap(element);
            aggregationMap.putAll(pageHeaders);
            this.headers = Collections.unmodifiableMap(aggregationMap);
            String pathValue = element.getAttribute("path");
            this.path = pathValue.charAt(0) != '/' ? "/" + pathValue : pathValue;
            String value = element.getAttribute("classname");
            if (value != null) {
                if (pagesPackage.trim().length() > 0) {
                    value = pagesPackage + "." + value;
                }
            } else {
                String msg = "No classname defined for page path " + this.path;
                throw new RuntimeException(msg);
            }
            this.pageClass = Class.forName(value);
            if (!(class$net$sf$click$Page == null ? (class$net$sf$click$Page = ClickApp.class$("net.sf.click.Page")) : class$net$sf$click$Page).isAssignableFrom(this.pageClass)) {
                String msg = "Page class " + value + " is not a subclass of net.sf.clic.Page";
                throw new RuntimeException(msg);
            }
        }

        private PageElm(String path, Class pageClass, Map commonHeaders, Class formatClass) {
            this.formatClass = formatClass;
            this.headers = Collections.unmodifiableMap(commonHeaders);
            this.pageClass = pageClass;
            this.path = path;
        }

        private PageElm(String classname, String path, Class formatClass) throws ClassNotFoundException {
            this.formatClass = formatClass;
            this.headers = Collections.EMPTY_MAP;
            this.pageClass = Class.forName(classname);
            this.path = path;
        }

        private Class getFormatClass() {
            return this.formatClass;
        }

        private Map getHeaders() {
            return this.headers;
        }

        private Class getPageClass() {
            return this.pageClass;
        }

        private String getPath() {
            return this.path;
        }
    }
}

