/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cathcart.plugin;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.cathcart.plugin.MojoBase;
import net.sourceforge.cathcart.typedefs.PropertyType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MojoBuild
extends MojoBase {
    private static final String CATHCART_BUILD_XML = "cathcart.build.xml";

    public static void main(String[] args) throws IOException {
        MojoBuild build = new MojoBuild();
        build.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create() throws IOException {
        OutputStreamWriter writer = null;
        try {
            try {
                writer = new FileWriter("maven-cathcart-plugin/src/main/scripts/cathcart.build.xml");
            }
            catch (IOException e) {
                writer = new FileWriter("src/main/scripts/cathcart.build.xml");
            }
            Document doc = this.parser.parse();
            this.buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.append("<project xmlns:cathcart=\"antlib:net.sourceforge.cathcart\">");
            List tools = this.parser.getTools(doc);
            for (Element t : tools) {
                String toolName = t.getNodeName();
                this.appendTarget(doc, "check", toolName);
                this.appendTarget(doc, "checkprevious", toolName);
            }
            this.append("</project>");
            writer.write(this.buffer.toString());
            writer.flush();
        }
        finally {
            writer.close();
        }
    }

    private void appendTarget(Document doc, String prefix, String toolName) {
        ++this.i;
        this.append("<target name=\"" + prefix + "_" + toolName + "\" >");
        ++this.i;
        String storedir = "";
        String backup = "";
        if (prefix.equals("checkprevious")) {
            storedir = " storedir=\"${checkprevious." + toolName + ".dir}\"";
            backup = " backup=\"${checkprevious." + toolName + ".backup}\"";
        }
        this.append("<cathcart:" + prefix + storedir + backup + " tool=\"" + toolName + "\" inxml=\"${" + toolName + ".report} \">");
        Map pts = this.parser.getPropertyTypes(doc, toolName);
        Collection values = pts.values();
        ++this.i;
        for (PropertyType propertyType : values) {
            String head = prefix + "." + toolName + "." + propertyType.getName();
            String limit = "";
            if (prefix.equals("check")) {
                limit = "limit=\"${" + head + ".limit}\" ";
            }
            this.append("<cathcart:propertytype name=\"" + propertyType.getName() + "\" " + "leeway=\"${" + head + ".leeway}\" " + "absolute=\"${" + head + ".absolute}\" " + limit + "/>");
        }
        --this.i;
        this.append("</cathcart:" + prefix + ">");
        --this.i;
        this.append("</target>");
        --this.i;
    }
}

