/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cathcart.plugin;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.cathcart.plugin.MojoBase;
import net.sourceforge.cathcart.typedefs.PropertyType;
import net.sourceforge.cathcart.typedefs.Trend;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mojo
extends MojoBase {
    private static final String CATHCART_MOJOS_XML = "cathcart.mojos.xml";

    public static void main(String[] args) throws IOException {
        Mojo mojo = new Mojo();
        mojo.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create() throws IOException {
        OutputStreamWriter writer = null;
        try {
            try {
                writer = new FileWriter("maven-cathcart-plugin/src/main/scripts/cathcart.mojos.xml");
            }
            catch (IOException e) {
                writer = new FileWriter("src/main/scripts/cathcart.mojos.xml");
            }
            Document doc = this.parser.parse();
            this.buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.append("<pluginMetadata>");
            ++this.i;
            this.append("<mojos>");
            List tools = this.parser.getTools(doc);
            for (Element t : tools) {
                String toolName = t.getNodeName();
                Map pts = this.parser.getPropertyTypes(doc, toolName);
                StringBuffer sb = this.parser.printList(pts.keySet());
                String description = "Checks the metrics " + sb.toString() + " generated by " + toolName + " (" + t.getAttribute("url") + ")";
                this.appendMojo(description, "check", toolName, pts);
                description = "Checks the metrics " + sb.toString() + " generated by " + toolName + " (" + t.getAttribute("url") + ")" + " have not deteriorated since the last successful build.";
                this.appendMojo(description, "checkprevious", toolName, pts);
            }
            this.append("</mojos>");
            --this.i;
            this.append("</pluginMetadata>");
            writer.write(this.buffer.toString());
            writer.flush();
        }
        finally {
            writer.close();
        }
    }

    private void appendMojo(String description, String prefix, String toolName, Map<String, PropertyType> pts) {
        ++this.i;
        this.append("<mojo>");
        ++this.i;
        this.append("<goal>" + prefix + "_" + toolName + "</goal>");
        this.append("<call>" + prefix + "_" + toolName + "</call>");
        this.append("<description>" + description + "</description>");
        this.append("<parameters>");
        this.appendReport(toolName);
        Collection<PropertyType> values = pts.values();
        for (PropertyType propertyType : values) {
            this.appendLeeway(prefix, toolName, propertyType);
            this.appendAbsolute(prefix, toolName, propertyType);
            if (!prefix.equals("check")) continue;
            this.appendLimit(prefix, toolName, propertyType);
        }
        if (prefix.equals("checkprevious")) {
            this.appendStoredir(toolName);
            this.appendBackup(toolName);
        }
        this.append("</parameters>");
        --this.i;
        this.append("</mojo>");
        --this.i;
    }

    private void appendLeeway(String prefix, String toolName, PropertyType propertyType) {
        String suffix = "leeway";
        String propertyDescription = "The allowed leeway in the value of " + propertyType.getName() + " when compaired to the last successful build.";
        if (prefix.equals("check")) {
            propertyDescription = "The allowed leeway in the value of " + propertyType.getName() + " when compaired to the given limit.";
        }
        String propertyTypeName = prefix + "." + toolName + "." + propertyType.getName() + "." + suffix;
        this.appendProperty(false, "0", "java.lang.Double", propertyDescription, propertyTypeName);
    }

    private void appendAbsolute(String prefix, String toolName, PropertyType propertyType) {
        String suffix = "absolute";
        String propertyDescription = "Is the leeway for " + propertyType.getName() + " given as an absolute value (true) or a percentage (false)?";
        String propertyTypeName = prefix + "." + toolName + "." + propertyType.getName() + "." + suffix;
        this.appendProperty(false, Boolean.FALSE.toString(), "java.lang.Boolean", propertyDescription, propertyTypeName);
    }

    private void appendLimit(String prefix, String toolName, PropertyType propertyType) {
        String suffix = "limit";
        String propertyDescriptionPrefix = "Fails if " + propertyType.getName();
        String propertyDescription = "";
        String propertyTypeName = prefix + "." + toolName + "." + propertyType.getName() + "." + suffix;
        String defaultValue = "99999";
        if (propertyType.getDesiredTrend().equals(Trend.upward.toString())) {
            defaultValue = "0";
            propertyDescription = propertyDescriptionPrefix + " is less than this value.";
        } else {
            propertyDescription = propertyDescriptionPrefix + " is more than this value.";
        }
        this.appendProperty(false, defaultValue, "java.lang.Double", propertyDescription, propertyTypeName);
    }

    private void appendProperty(boolean required, String defaultValue, String type, String propertyDescription, String parameterName) {
        ++this.i;
        this.append("<parameter>");
        ++this.i;
        this.append("<name>" + parameterName + "</name>");
        this.append("<property>" + parameterName + "</property>");
        this.append("<required>" + required + "</required>");
        if (defaultValue != null) {
            this.append("<defaultValue>" + defaultValue + "</defaultValue>");
        }
        this.append("<expression>${" + parameterName + "}</expression>");
        this.append("<type>" + type + "</type>");
        this.append("<description>" + propertyDescription + "</description>");
        --this.i;
        this.append("</parameter>");
        --this.i;
    }

    private void appendReport(String toolName) {
        this.appendProperty(true, null, "java.io.File", "The xml report produced by " + toolName + " which contains the raw data for checking.", toolName + ".report");
    }

    private void appendStoredir(String toolName) {
        this.appendProperty(false, "previous", "java.lang.String", "The directory where results are saved between builds.", "checkprevious." + toolName + ".dir");
    }

    private void appendBackup(String toolName) {
        this.appendProperty(false, "true", "java.lang.Boolean", "Make a backup of the previous result file when it is replaced.", "checkprevious." + toolName + ".backup");
    }
}

