/*
 * Decompiled with CFR 0.152.
 */
package net.sf.buildbox.strictlogging.tests;

import java.util.Date;
import junit.framework.TestCase;
import net.sf.buildbox.strictlogging.api.LogMessage;
import net.sf.buildbox.strictlogging.api.Severity;
import net.sf.buildbox.strictlogging.api.StrictCatalog;
import net.sf.buildbox.strictlogging.api.StrictCatalogEntry;
import net.sf.buildbox.strictlogging.api.StrictCatalogFactory;
import net.sf.buildbox.strictlogging.api.StrictLogger;

public class AbstractLoggerTest
extends TestCase {
    protected StrictLogger logger;

    public void testSimpleDebug() {
        this.logger.trace(new Object[]{"HELLO"});
        StrictLogger sublog = this.logger.getSubLogger("SubLog");
        sublog.debug(new Object[]{"Hello from sublog"});
    }

    public void testConcatenation() {
        char c = 'X';
        this.logger.debug(new Object[]{"Five: ", 5, ", current time: ", new Date(), ", one character: ", Character.valueOf(c)});
    }

    public void testCatalog() {
        Catalog cat = (Catalog)StrictCatalogFactory.getCatalog(Catalog.class);
        this.logger.log(cat.badMood());
        this.logger.log(cat.hello("World"));
        this.logger.log(cat.messageWithNumericParam(15));
        this.logger.log(cat.messageWithDateParam(new Date()));
    }

    public void testException() {
        this.logger.debug((Throwable)new RuntimeException("Just testing how exception looks in the log"), new Object[]{"Testing an exception"});
    }

    private static interface Catalog
    extends StrictCatalog {
        @StrictCatalogEntry(severity=Severity.INFO, format="Hello %s")
        public LogMessage hello(String var1);

        @StrictCatalogEntry(severity=Severity.INFO, format="I like to play Lloyd's %d :)")
        public LogMessage messageWithNumericParam(int var1);

        @StrictCatalogEntry(severity=Severity.INFO, format="Today, %tFT%1$tT.%1$tL, is a nice day")
        public LogMessage messageWithDateParam(Date var1);

        @StrictCatalogEntry(severity=Severity.ERROR, format="I have a bad mood")
        public LogMessage badMood();
    }
}

