/*
 * Decompiled with CFR 0.152.
 */
package com.syndicate.deployment.model.terraform;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.security.InvalidParameterException;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TerraformLambdaVpcConfig {
    @JsonProperty(value="subnet_ids")
    private String[] subnetIds;
    @JsonProperty(value="security_group_ids ")
    private String[] securityGroupIds;

    public static Builder builder() {
        return new Builder();
    }

    public String[] getSubnetIds() {
        return this.subnetIds;
    }

    public String[] getSecurityGroupIds() {
        return this.securityGroupIds;
    }

    public static class Builder {
        private TerraformLambdaVpcConfig vpcConfig = new TerraformLambdaVpcConfig();

        public Builder withSubnetIds(String[] subnetIds) {
            this.assertArray(subnetIds, "Subnet ids cannot be null or empty");
            this.vpcConfig.subnetIds = subnetIds;
            return this;
        }

        public Builder withSecurityGroupIds(String[] securityGroupIds) {
            this.assertArray(securityGroupIds, "Security group ids array cannot be null or empty");
            this.vpcConfig.securityGroupIds = securityGroupIds;
            return this;
        }

        public TerraformLambdaVpcConfig build() {
            this.assertArray(this.vpcConfig.subnetIds, "Subnet ids cannot be null or empty");
            this.assertArray(this.vpcConfig.securityGroupIds, "Security group ids array cannot be null or empty");
            return this.vpcConfig;
        }

        private void assertArray(String[] subnetIds, String errorMessage) {
            if (subnetIds == null || subnetIds.length == 0) {
                throw new InvalidParameterException(errorMessage);
            }
        }
    }
}

