/*
 * Decompiled with CFR 0.152.
 */
package com.syndicate.deployment.model.terraform;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.syndicate.deployment.model.DeploymentRuntime;
import com.syndicate.deployment.model.terraform.TerraformLambdaVpcConfig;
import java.security.InvalidParameterException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TerraformLambdaConfiguration {
    @JsonProperty(value="filename")
    private String deploymentPackageName;
    @JsonProperty(value="function_name")
    private String functionName;
    @JsonProperty(value="handler")
    private String handler;
    @JsonProperty(value="role")
    private String roleArn;
    @JsonProperty(value="memory_size")
    private long memorySize;
    @JsonProperty(value="timeout")
    private long timeoutInSec;
    @JsonProperty(value="runtime")
    private DeploymentRuntime runtime;
    @JsonProperty(value="publish")
    private boolean publishNewVersion;
    @JsonProperty(value="vpc_config")
    private TerraformLambdaVpcConfig vpcConfig;
    @JsonProperty(value="environment")
    private Map<String, Object> environmentVariables;
    @JsonProperty(value="tags")
    private Map<String, String> tags;
    @JsonProperty(value="dead_letter_config")
    private Map<String, String> deadLetterConfig;

    public static Builder builder() {
        return new Builder();
    }

    public String getDeploymentPackageName() {
        return this.deploymentPackageName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getHandler() {
        return this.handler;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public long getMemorySize() {
        return this.memorySize;
    }

    public DeploymentRuntime getRuntime() {
        return this.runtime;
    }

    public boolean isPublishNewVersion() {
        return this.publishNewVersion;
    }

    public TerraformLambdaVpcConfig getVpcConfig() {
        return this.vpcConfig;
    }

    public Map<String, Object> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public static class Builder {
        private static final String DL_CONFIG_ARN = "target_arn";
        private TerraformLambdaConfiguration configuration = new TerraformLambdaConfiguration();

        public Builder withDeploymentPackageName(String deploymentPackageName) {
            Objects.requireNonNull(deploymentPackageName, "Deployment package name cannot be null");
            this.configuration.deploymentPackageName = deploymentPackageName;
            return this;
        }

        public Builder withFunctionName(String functionName) {
            Objects.requireNonNull(functionName, "Function name cannot be null");
            this.configuration.functionName = functionName;
            return this;
        }

        public Builder withHandler(String handler) {
            Objects.requireNonNull(handler, "Function handler cannot be null");
            this.configuration.handler = handler;
            return this;
        }

        public Builder withRole(String roleArn) {
            Objects.requireNonNull(roleArn, "Role arn cannot be null");
            this.configuration.roleArn = roleArn;
            return this;
        }

        public Builder withMemorySize(long memorySize) {
            if (memorySize <= 0L) {
                throw new InvalidParameterException("Memory cannot be negative or 0");
            }
            this.configuration.memorySize = memorySize;
            return this;
        }

        public Builder withRuntime(DeploymentRuntime runtime) {
            Objects.requireNonNull(runtime, "Deployment runtime cannot be null");
            this.configuration.runtime = runtime;
            return this;
        }

        public Builder withPublishNewVersion(boolean publishNewVersion) {
            this.configuration.publishNewVersion = publishNewVersion;
            return this;
        }

        public Builder withVpcConfig(TerraformLambdaVpcConfig config) {
            Objects.requireNonNull(config, "Lambda vpc vpcConfig cannot be null");
            this.configuration.vpcConfig = config;
            return this;
        }

        public Builder withEnvironmentVariables(Map<String, Object> environmentVariables) {
            Objects.requireNonNull(environmentVariables, "Environment variables cannot be null");
            if (environmentVariables.isEmpty()) {
                throw new InvalidParameterException("Environment variables cannot be empty");
            }
            this.configuration.environmentVariables = environmentVariables;
            return this;
        }

        public Builder withTags(Map<String, String> tags) {
            Objects.requireNonNull(tags, "Tags variables cannot be null");
            if (tags.isEmpty()) {
                throw new InvalidParameterException("Tags variables cannot be empty");
            }
            this.configuration.tags = tags;
            return this;
        }

        public Builder withDeadLetterConfig(String deadLetterTargetResourceArn) {
            Objects.requireNonNull(deadLetterTargetResourceArn, "Dead letter resource arn cannot be null");
            this.configuration.deadLetterConfig = Collections.singletonMap(DL_CONFIG_ARN, deadLetterTargetResourceArn);
            return this;
        }

        public Builder withTimeout(long timeout) {
            if (timeout <= 0L) {
                throw new InvalidParameterException("Memory cannot be negative or 0");
            }
            this.configuration.timeoutInSec = timeout;
            return this;
        }

        public TerraformLambdaConfiguration build() {
            Objects.requireNonNull(this.configuration.functionName, "Function name cannot be null");
            Objects.requireNonNull(this.configuration.handler, "Function handler cannot be null");
            Objects.requireNonNull(this.configuration.roleArn, "Role arn cannot be null");
            Objects.requireNonNull(this.configuration.runtime, "Deployment runtime cannot be null");
            return this.configuration;
        }
    }
}

