/*
 * Decompiled with CFR 0.152.
 */
package com.syndicate.deployment.model.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.syndicate.deployment.annotations.events.FunctionResponseType;
import com.syndicate.deployment.model.EventSourceType;
import com.syndicate.deployment.model.events.EventSourceItem;
import java.util.Arrays;
import java.util.Objects;

public class SqsTriggerEventSourceItem
extends EventSourceItem {
    @JsonProperty(value="target_queue")
    private String targetQueue;
    @JsonProperty(value="batch_size")
    private int batchSize;
    @JsonProperty(value="function_response_types")
    private FunctionResponseType[] functionResponseTypes;

    private SqsTriggerEventSourceItem() {
    }

    public String getTargetQueue() {
        return this.targetQueue;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public FunctionResponseType[] getFunctionResponseTypes() {
        return this.functionResponseTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqsTriggerEventSourceItem that = (SqsTriggerEventSourceItem)o;
        return this.batchSize == that.batchSize && this.eventSourceType == that.eventSourceType && this.targetQueue.equals(that.targetQueue) && this.functionResponseTypes == that.functionResponseTypes;
    }

    public int hashCode() {
        int result = this.targetQueue.hashCode();
        result = 31 * result + this.eventSourceType.hashCode();
        result = 31 * result + this.batchSize;
        result = 31 * result + Arrays.hashCode((Object[])this.functionResponseTypes);
        return result;
    }

    @Override
    public String toString() {
        return "SqsTriggerEventSourceItem{targetQueue='" + this.targetQueue + "', batchSize=" + this.batchSize + ", functionResponseTypes=" + Arrays.toString((Object[])this.functionResponseTypes) + "}";
    }

    public static class Builder {
        private final SqsTriggerEventSourceItem triggerEventSourceItem = new SqsTriggerEventSourceItem();

        public Builder withTargetQueue(String targetQueue) {
            Objects.requireNonNull(targetQueue, "TargetQueue cannot be null");
            this.triggerEventSourceItem.targetQueue = targetQueue;
            return this;
        }

        public Builder withBatchSize(int batchSize) {
            Objects.requireNonNull(Integer.valueOf(batchSize), "BatchSize cannot be null");
            this.triggerEventSourceItem.batchSize = batchSize;
            return this;
        }

        public SqsTriggerEventSourceItem build() {
            this.triggerEventSourceItem.eventSourceType = EventSourceType.SQS_TRIGGER;
            return this.triggerEventSourceItem;
        }

        public Builder withFunctionResponseTypes(FunctionResponseType[] functionResponseTypes) {
            this.triggerEventSourceItem.functionResponseTypes = functionResponseTypes;
            return this;
        }
    }
}

