/*
 * Decompiled with CFR 0.152.
 */
package com.syndicate.deployment.model.events;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.syndicate.deployment.model.EventSourceType;
import com.syndicate.deployment.model.RegionScope;
import com.syndicate.deployment.model.events.EventSourceItem;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SnsTriggerEventSourceItem
extends EventSourceItem {
    @JsonProperty(value="target_topic")
    private String targetTopic;
    @JsonProperty(value="region")
    private String regionScope;

    private SnsTriggerEventSourceItem() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnsTriggerEventSourceItem that = (SnsTriggerEventSourceItem)o;
        return this.eventSourceType == that.eventSourceType && this.targetTopic.equals(that.targetTopic);
    }

    public int hashCode() {
        return this.targetTopic.hashCode() + this.eventSourceType.hashCode();
    }

    @Override
    public String toString() {
        return "SnsTriggerEventSourceItem{targetTopic='" + this.targetTopic + "'} " + super.toString();
    }

    public static class Builder {
        private final SnsTriggerEventSourceItem snsTriggerEventSourceItem = new SnsTriggerEventSourceItem();

        public Builder withTargetTopic(String targetTopic) {
            Objects.requireNonNull(targetTopic, "TargetTopic cannot be null");
            this.snsTriggerEventSourceItem.targetTopic = targetTopic;
            return this;
        }

        public Builder withRegionScope(RegionScope regionScope) {
            Objects.requireNonNull(regionScope, "Region scope cannot be null");
            this.snsTriggerEventSourceItem.regionScope = regionScope.getName();
            return this;
        }

        public SnsTriggerEventSourceItem build() {
            this.snsTriggerEventSourceItem.eventSourceType = EventSourceType.SNS_TOPIC_TRIGGER;
            return this.snsTriggerEventSourceItem;
        }
    }
}

