/*
 * Decompiled with CFR 0.152.
 */
package com.syndicate.deployment.model.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.syndicate.deployment.model.EventSourceType;
import com.syndicate.deployment.model.events.EventSourceItem;
import java.util.Objects;

public class ScheduleEventSourceItem
extends EventSourceItem {
    @JsonProperty(value="target_schedule")
    private String targetSchedule;

    private ScheduleEventSourceItem() {
    }

    public String getTargetSchedule() {
        return this.targetSchedule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduleEventSourceItem that = (ScheduleEventSourceItem)o;
        return this.eventSourceType == that.eventSourceType && this.targetSchedule.equals(that.targetSchedule);
    }

    public int hashCode() {
        return this.targetSchedule.hashCode() + this.eventSourceType.hashCode();
    }

    @Override
    public String toString() {
        return "ScheduleEventSourceItem{targetSchedule='" + this.targetSchedule + "'} " + super.toString();
    }

    public static class Builder {
        private final ScheduleEventSourceItem scheduleEventSourceItem = new ScheduleEventSourceItem();

        public Builder withTargetSchedule(String targetSchedule) {
            Objects.requireNonNull(targetSchedule, "TargetSchedule cannot be null");
            this.scheduleEventSourceItem.targetSchedule = targetSchedule;
            return this;
        }

        public Builder withEventSourceType(EventSourceType eventSourceType) {
            Objects.requireNonNull(eventSourceType, "ResourceType cannot be null");
            this.scheduleEventSourceItem.eventSourceType = eventSourceType;
            return this;
        }

        public ScheduleEventSourceItem build() {
            return this.scheduleEventSourceItem;
        }
    }
}

