/*
 * Decompiled with CFR 0.152.
 */
package com.syndicate.deployment.model.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.syndicate.deployment.model.EventSourceType;
import com.syndicate.deployment.model.events.EventSourceItem;
import java.util.Arrays;
import java.util.Objects;

public class S3EventSourceItem
extends EventSourceItem {
    @JsonProperty(value="target_bucket")
    private String targetBucket;
    @JsonProperty(value="s3_events")
    private String[] events;

    private S3EventSourceItem() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3EventSourceItem that = (S3EventSourceItem)o;
        if (!this.targetBucket.equals(that.targetBucket)) {
            return false;
        }
        return this.eventSourceType == that.eventSourceType && Arrays.equals(this.events, that.events);
    }

    public int hashCode() {
        int result = this.targetBucket.hashCode();
        result = 31 * result + this.eventSourceType.hashCode();
        result = 31 * result + Arrays.hashCode(this.events);
        return result;
    }

    @Override
    public String toString() {
        return "S3EventSourceItem{targetBucket='" + this.targetBucket + "', events=" + Arrays.toString(this.events) + "} " + super.toString();
    }

    public static class Builder {
        private final S3EventSourceItem s3EventSourceItem = new S3EventSourceItem();

        public Builder withTargetBucket(String targetBucket) {
            Objects.requireNonNull(targetBucket, "TargetBucket cannot be null");
            this.s3EventSourceItem.targetBucket = targetBucket;
            return this;
        }

        public Builder withEvents(String[] events) {
            Objects.requireNonNull(events, "Events cannot be null");
            if (events.length == 0) {
                throw new IllegalArgumentException("Events cannot be empty");
            }
            this.s3EventSourceItem.events = events;
            return this;
        }

        public S3EventSourceItem build() {
            this.s3EventSourceItem.eventSourceType = EventSourceType.S3_TRIGGER;
            return this.s3EventSourceItem;
        }
    }
}

