/*
 * Decompiled with CFR 0.152.
 */
package com.syndicate.deployment.model.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.syndicate.deployment.model.EventSourceType;
import com.syndicate.deployment.model.events.EventSourceItem;
import java.util.Objects;

public class DynamoDbTriggerEventSourceItem
extends EventSourceItem {
    @JsonProperty(value="target_table")
    private String targetTable;
    @JsonProperty(value="batch_size")
    private int batchSize;

    private DynamoDbTriggerEventSourceItem() {
    }

    public String getTargetTable() {
        return this.targetTable;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamoDbTriggerEventSourceItem that = (DynamoDbTriggerEventSourceItem)o;
        return this.batchSize == that.batchSize && this.eventSourceType == that.eventSourceType && this.targetTable.equals(that.targetTable);
    }

    public int hashCode() {
        int result = this.targetTable.hashCode();
        result = 31 * result + this.eventSourceType.hashCode();
        result = 31 * result + this.batchSize;
        return result;
    }

    @Override
    public String toString() {
        return "DynamoDbTriggerEventSourceItem{targetTable='" + this.targetTable + "', batchSize=" + this.batchSize + "} " + super.toString();
    }

    public static class Builder {
        private final DynamoDbTriggerEventSourceItem triggerEventSourceItem = new DynamoDbTriggerEventSourceItem();

        public Builder withTargetTable(String targetTable) {
            Objects.requireNonNull(targetTable, "TargetTable cannot be null");
            this.triggerEventSourceItem.targetTable = targetTable;
            return this;
        }

        public Builder withBatchSize(int batchSize) {
            Objects.requireNonNull(Integer.valueOf(batchSize), "BatchSize cannot be null");
            this.triggerEventSourceItem.batchSize = batchSize;
            return this;
        }

        public DynamoDbTriggerEventSourceItem build() {
            this.triggerEventSourceItem.eventSourceType = EventSourceType.DYNAMODB_TRIGGER;
            return this.triggerEventSourceItem;
        }
    }
}

