/*
 * Decompiled with CFR 0.152.
 */
package com.syndicate.deployment.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.syndicate.deployment.model.Architecture;
import com.syndicate.deployment.model.DeploymentRuntime;
import com.syndicate.deployment.model.ResourceType;
import java.security.InvalidParameterException;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class LayerConfiguration {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="runtimes")
    private DeploymentRuntime[] runtimes;
    @JsonProperty(value="resource_type")
    private ResourceType resourceType;
    @JsonProperty(value="licence")
    private String licence;
    @JsonProperty(value="deployment_package")
    private String deploymentPackage;
    @JsonProperty(value="libraries")
    private String[] libraries;
    @JsonProperty(value="architectures")
    private Architecture[] architectures;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLicence() {
        return this.licence;
    }

    public void setLicence(String licence) {
        this.licence = licence;
    }

    public String getDeploymentPackage() {
        return this.deploymentPackage;
    }

    public void setDeploymentPackage(String deploymentPackage) {
        this.deploymentPackage = deploymentPackage;
    }

    public String[] getLibraries() {
        return this.libraries;
    }

    public LayerConfiguration setLibraries(String[] libraries) {
        this.libraries = libraries;
        return this;
    }

    public DeploymentRuntime[] getRuntimes() {
        return this.runtimes;
    }

    public void setRuntimes(DeploymentRuntime[] runtimes) {
        this.runtimes = runtimes;
    }

    public Architecture[] getArchitectures() {
        return this.architectures;
    }

    public LayerConfiguration setArchitectures(Architecture[] architectures) {
        this.architectures = architectures;
        return this;
    }

    public static class Builder {
        private final LayerConfiguration layerConfiguration = new LayerConfiguration();

        public Builder withName(String name) {
            Objects.requireNonNull(name, "Layer name cannot be null");
            if (name.isEmpty()) {
                throw new InvalidParameterException("Layer name cannot be empty");
            }
            this.layerConfiguration.setName(name);
            return this;
        }

        public Builder withDescription(String description) {
            Objects.requireNonNull(description, "Layer description cannot be null");
            if (description.isEmpty()) {
                throw new InvalidParameterException("Layer description cannot be empty");
            }
            this.layerConfiguration.setDescription(description);
            return this;
        }

        public Builder withRuntimes(DeploymentRuntime runtime) {
            Objects.requireNonNull(runtime, "Layer runtimes cannot be null");
            this.layerConfiguration.setRuntimes(new DeploymentRuntime[]{runtime});
            return this;
        }

        public Builder withLicence(String licence) {
            Objects.requireNonNull(licence, "Layer licence cannot be null");
            if (licence.isEmpty()) {
                throw new InvalidParameterException("Layer licence cannot be empty");
            }
            this.layerConfiguration.setLicence(licence);
            return this;
        }

        public Builder withDeploymentPackage(String deploymentPackage) {
            Objects.requireNonNull(deploymentPackage, "Layer deploymentPackage cannot be null");
            if (deploymentPackage.isEmpty()) {
                throw new InvalidParameterException("Layer deploymentPackage cannot be empty");
            }
            this.layerConfiguration.setDeploymentPackage(deploymentPackage);
            return this;
        }

        public Builder withResourceType(ResourceType resourceType) {
            Objects.requireNonNull(resourceType, "Resource type cannot be null");
            this.layerConfiguration.resourceType = resourceType;
            return this;
        }

        public LayerConfiguration build() {
            return this.layerConfiguration;
        }
    }
}

