/*
 * Decompiled with CFR 0.152.
 */
package com.syndicate.deployment.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.syndicate.deployment.model.Architecture;
import com.syndicate.deployment.model.DependencyItem;
import com.syndicate.deployment.model.DeploymentRuntime;
import com.syndicate.deployment.model.LambdaSnapStart;
import com.syndicate.deployment.model.ProvisionedConcurrency;
import com.syndicate.deployment.model.RegionScope;
import com.syndicate.deployment.model.ResourceType;
import com.syndicate.deployment.model.events.EventSourceItem;
import com.syndicate.deployment.model.lambda.url.UrlConfig;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class LambdaConfiguration {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="lambda_path")
    private String path;
    @JsonProperty(value="version")
    private String version;
    @JsonProperty(value="func_name")
    private String function;
    @JsonProperty(value="deployment_package")
    private String packageName;
    @JsonProperty(value="max_concurrency")
    private Integer concurrentExecutions;
    @JsonProperty(value="provisioned_concurrency")
    private ProvisionedConcurrency provisionedConcurrency;
    @JsonProperty(value="resource_type")
    private ResourceType resourceType;
    @JsonProperty(value="runtime")
    private DeploymentRuntime runtime;
    @JsonProperty(value="architectures")
    private Architecture[] architectures;
    @JsonProperty(value="iam_role_name")
    private String role;
    @JsonProperty(value="memory")
    private long memory;
    @JsonProperty(value="timeout")
    private long timeout;
    @JsonProperty(value="region")
    private String region;
    @JsonProperty(value="subnet_ids")
    private String[] subnetIds;
    @JsonProperty(value="security_group_ids")
    private String[] securityGroupIds;
    @JsonProperty(value="dependencies")
    private Set<DependencyItem> dependencies;
    @JsonProperty(value="event_sources")
    private Set<EventSourceItem> eventSources;
    @JsonProperty(value="env_variables")
    private Map<String, Object> variables;
    @JsonProperty(value="tags")
    private Map<String, String> tags;
    @JsonProperty(value="dl_resource_name")
    private String dlResourceName;
    @JsonProperty(value="dl_resource_type")
    private String dlResourceType;
    @JsonProperty(value="tracing_mode")
    private String tracingMode;
    @JsonProperty(value="publish_version")
    private boolean isPublishVersion;
    @JsonProperty(value="alias")
    private String alias;
    @JsonProperty(value="layers")
    private String[] layers;
    @JsonProperty(value="logs_expiration")
    private String logsExpiration;
    @JsonProperty(value="snap_start")
    private LambdaSnapStart snapStart;
    @JsonProperty(value="resource_group")
    private String resourceGroup;
    @JsonProperty(value="url_config")
    private UrlConfig urlConfig;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public String getVersion() {
        return this.version;
    }

    public String getFunction() {
        return this.function;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Integer getConcurrentExecutions() {
        return this.concurrentExecutions;
    }

    public void setConcurrentExecutions(Integer concurrentExecutions) {
        this.concurrentExecutions = concurrentExecutions;
    }

    public ProvisionedConcurrency getProvisionedConcurrency() {
        return this.provisionedConcurrency;
    }

    public void setProvisionedConcurrency(ProvisionedConcurrency provisionedConcurrency) {
        this.provisionedConcurrency = provisionedConcurrency;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public DeploymentRuntime getRuntime() {
        return this.runtime;
    }

    public Architecture[] getArchitectures() {
        return this.architectures;
    }

    public String getRole() {
        return this.role;
    }

    public long getMemory() {
        return this.memory;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public Set<DependencyItem> getDependencies() {
        return this.dependencies;
    }

    public Set<EventSourceItem> getEventSources() {
        return this.eventSources;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public String getDlResourceName() {
        return this.dlResourceName;
    }

    public void setDlResourceName(String dlResourceName) {
        this.dlResourceName = dlResourceName;
    }

    public String getDlResourceType() {
        return this.dlResourceType;
    }

    public void setDlResourceType(String dlResourceType) {
        this.dlResourceType = dlResourceType;
    }

    public String getTracingMode() {
        return this.tracingMode;
    }

    public void setTracingMode(String tracingMode) {
        this.tracingMode = tracingMode;
    }

    @JsonIgnore
    public boolean isPublishVersion() {
        return this.isPublishVersion;
    }

    public void setPublishVersion(boolean publishVersion) {
        this.isPublishVersion = publishVersion;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String[] getSubnetIds() {
        return this.subnetIds;
    }

    public void setSubnetIds(String[] subnetIds) {
        this.subnetIds = subnetIds;
    }

    public String[] getSecurityGroupIds() {
        return this.securityGroupIds;
    }

    public void setSecurityGroupIds(String[] securityGroupIds) {
        this.securityGroupIds = securityGroupIds;
    }

    public String[] getLayers() {
        return this.layers;
    }

    public void setLayers(String[] layers) {
        this.layers = layers;
    }

    public void setLogsExpiration(String logsExpiration) {
        this.logsExpiration = logsExpiration;
    }

    public LambdaSnapStart getSnapStart() {
        return this.snapStart;
    }

    public void setSnapStart(LambdaSnapStart snapStart) {
        this.snapStart = snapStart;
    }

    public void setUrlConfig(UrlConfig urlConfig) {
        this.urlConfig = urlConfig;
    }

    public String toString() {
        return "LambdaConfiguration{name='" + this.name + "'path='" + this.path + "', version='" + this.version + "', function='" + this.function + "', packageName='" + this.packageName + "', concurrentExecutions=" + this.concurrentExecutions + ", resourceType=" + this.resourceType + ", runtime=" + this.runtime + ", architectures=" + Arrays.toString((Object[])this.architectures) + ", role='" + this.role + "', memory=" + this.memory + ", timeout=" + this.timeout + ", region='" + this.region + "', subnetIds=" + Arrays.toString(this.subnetIds) + ", securityGroupIds=" + Arrays.toString(this.securityGroupIds) + ", dependencies=" + this.dependencies + ", eventSources=" + this.eventSources + ", variables=" + this.variables + ", tags=" + this.tags + ", dlResourceName='" + this.dlResourceName + "', dlResourceType='" + this.dlResourceType + "', tracingMode='" + this.tracingMode + "', alias='" + this.alias + "', urlConfig='" + this.urlConfig + "'}";
    }

    public static class Builder {
        private final LambdaConfiguration configuration = new LambdaConfiguration();

        public Builder withName(String name) {
            Objects.requireNonNull(name, "Name cannot be null");
            this.configuration.name = name;
            return this;
        }

        public Builder withPath(String path) {
            Objects.requireNonNull(path, "Path cannot be null");
            this.configuration.path = path;
            return this;
        }

        public Builder withVersion(String version) {
            Objects.requireNonNull(version, "Version cannot be null");
            this.configuration.version = version;
            return this;
        }

        public Builder withFunction(String function) {
            Objects.requireNonNull(function, "Function cannot be null");
            this.configuration.function = function;
            return this;
        }

        public Builder withRegionScope(RegionScope regionScope) {
            Objects.requireNonNull(regionScope, "region scope cannot be null");
            this.configuration.region = regionScope.getName();
            return this;
        }

        public Builder withPackageName(String path) {
            Objects.requireNonNull(path, "Path cannot be null");
            this.configuration.packageName = path;
            return this;
        }

        public Builder withConcurrentExecutions(Integer concurrentExecutions) {
            Objects.requireNonNull(concurrentExecutions, "\u0421oncurrent executions cannot be null");
            this.configuration.concurrentExecutions = concurrentExecutions;
            return this;
        }

        public Builder withProvisionedConcurrency(ProvisionedConcurrency provisionedConcurrency) {
            Objects.requireNonNull(provisionedConcurrency, "Provisioned concurrency configuration object cannot be null");
            this.configuration.provisionedConcurrency = provisionedConcurrency;
            return this;
        }

        public Builder withResourceType(ResourceType resourceType) {
            Objects.requireNonNull(resourceType, "ResourceType cannot be null");
            this.configuration.resourceType = resourceType;
            return this;
        }

        public Builder withRuntime(DeploymentRuntime deploymentRuntime) {
            Objects.requireNonNull(deploymentRuntime, "DeploymentRuntime cannot be null");
            this.configuration.runtime = deploymentRuntime;
            return this;
        }

        public Builder withArchitectures(Architecture[] architectures) {
            Objects.requireNonNull(architectures, "Architecture cannot be null");
            this.configuration.architectures = architectures;
            return this;
        }

        public Builder withRole(String role) {
            Objects.requireNonNull(role, "Role cannot be null");
            this.configuration.role = role;
            return this;
        }

        public Builder withMemory(long memory) {
            if (memory <= 0L) {
                throw new InvalidParameterException("Memory cannot be negative or 0");
            }
            this.configuration.memory = memory;
            return this;
        }

        public Builder withTimeout(long timeout) {
            if (timeout <= 0L) {
                throw new InvalidParameterException("Timeout cannot be negative or 0");
            }
            this.configuration.timeout = timeout;
            return this;
        }

        public Builder withDependencies(Set<DependencyItem> dependencies) {
            Objects.requireNonNull(dependencies, "Dependencies cannot be null");
            this.configuration.dependencies = dependencies;
            return this;
        }

        public Builder withEventSources(Set<EventSourceItem> events) {
            Objects.requireNonNull(events, "Events cannot be null");
            this.configuration.eventSources = events;
            return this;
        }

        public Builder withVariables(Map<String, Object> variables) {
            Objects.requireNonNull(variables, "Variables cannot be null");
            this.configuration.variables = variables;
            return this;
        }

        public Builder withTags(Map<String, String> tags) {
            Objects.requireNonNull(tags, "Tags cannot be null");
            this.configuration.tags = tags;
            return this;
        }

        public Builder withTracingMode(String tracingMode) {
            Objects.requireNonNull(tracingMode, "Tracing mode cannot be null");
            this.configuration.tracingMode = tracingMode;
            return this;
        }

        public Builder withDlResourceName(String dlResourceName) {
            Objects.requireNonNull(dlResourceName, "DL Resource name cannot be null");
            this.configuration.dlResourceName = dlResourceName;
            return this;
        }

        public Builder withDlResourceType(String dlResourceType) {
            Objects.requireNonNull(dlResourceType, "DL Resource type cannot be null");
            this.configuration.dlResourceType = dlResourceType;
            return this;
        }

        public Builder withSubnetIds(String[] subnetIds) {
            Objects.requireNonNull(subnetIds, "Subnet ids cannot be null");
            this.configuration.subnetIds = subnetIds;
            return this;
        }

        public Builder withSecurityGroupIds(String[] securityGroupIds) {
            Objects.requireNonNull(securityGroupIds, "Security group ids cannot be null");
            this.configuration.securityGroupIds = securityGroupIds;
            return this;
        }

        public Builder withPublishVersion(boolean isPublishVersion) {
            this.configuration.isPublishVersion = isPublishVersion;
            return this;
        }

        public Builder withAlias(String alias) {
            if (this.configuration.alias != null && alias.equals("")) {
                throw new InvalidParameterException("Alias cannot be empty");
            }
            this.configuration.alias = alias;
            return this;
        }

        public Builder withLayers(String[] layers) {
            Objects.requireNonNull(layers, "Array of layers names cannot be null");
            this.configuration.layers = layers;
            return this;
        }

        public Builder withSnapStart(LambdaSnapStart snapStart) {
            this.configuration.snapStart = snapStart;
            return this;
        }

        public Builder withResourceGroup(String resourceGroup) {
            if (resourceGroup != null && !resourceGroup.isEmpty()) {
                this.configuration.resourceGroup = resourceGroup;
            }
            return this;
        }

        public Builder withLogsExpirations(String logsExpirations) {
            this.configuration.logsExpiration = logsExpirations;
            return this;
        }

        public LambdaConfiguration build() {
            Objects.requireNonNull(this.configuration.name, "Name cannot be null");
            Objects.requireNonNull(this.configuration.path, "Path cannot be null");
            Objects.requireNonNull(this.configuration.version, "Version cannot be null");
            Objects.requireNonNull(this.configuration.function, "Function cannot be null");
            Objects.requireNonNull(this.configuration.packageName, "Package name cannot be null");
            Objects.requireNonNull(this.configuration.resourceType, "ResourceType cannot be null");
            Objects.requireNonNull(this.configuration.runtime, "DeploymentRuntime cannot be null");
            Objects.requireNonNull(this.configuration.architectures, "Architecture cannot be null");
            Objects.requireNonNull(this.configuration.role, "Role cannot be null");
            if (this.configuration.memory <= 0L) {
                throw new InvalidParameterException("Memory cannot be negative or 0");
            }
            if (this.configuration.timeout <= 0L) {
                throw new InvalidParameterException("Timeout cannot be negative or 0");
            }
            Objects.requireNonNull(this.configuration.dependencies, "Dependencies cannot be null");
            Objects.requireNonNull(this.configuration.eventSources, "Events cannot be null");
            Objects.requireNonNull(this.configuration.variables, "Variables cannot be null");
            Objects.requireNonNull(this.configuration.tags, "Tags cannot be null");
            Objects.requireNonNull(this.configuration.subnetIds, "Subnet ids cannot be null");
            Objects.requireNonNull(this.configuration.securityGroupIds, "Security group ids cannot be null");
            if (this.configuration.alias != null && this.configuration.alias.equals("")) {
                throw new InvalidParameterException("Alias cannot be empty");
            }
            return this.configuration;
        }
    }
}

