/*
 * Decompiled with CFR 0.152.
 */
package com.syndicate.deployment.model;

import com.fasterxml.jackson.annotation.JsonValue;
import com.syndicate.deployment.annotations.events.DynamoDbTriggerEventSource;
import com.syndicate.deployment.annotations.events.EventBridgeRuleSource;
import com.syndicate.deployment.annotations.events.RuleEventSource;
import com.syndicate.deployment.annotations.events.S3EventSource;
import com.syndicate.deployment.annotations.events.SnsEventSource;
import com.syndicate.deployment.annotations.events.SqsTriggerEventSource;
import com.syndicate.deployment.model.DependencyItem;
import com.syndicate.deployment.model.ResourceType;
import com.syndicate.deployment.model.events.DynamoDbTriggerEventSourceItem;
import com.syndicate.deployment.model.events.EventBridgeRuleSourceItem;
import com.syndicate.deployment.model.events.EventSourceItem;
import com.syndicate.deployment.model.events.RuleEventSourceItem;
import com.syndicate.deployment.model.events.S3EventSourceItem;
import com.syndicate.deployment.model.events.SnsTriggerEventSourceItem;
import com.syndicate.deployment.model.events.SqsTriggerEventSourceItem;
import java.lang.annotation.Annotation;

public enum EventSourceType {
    CLOUDWATCH_RULE_TRIGGER("cloudwatch_rule_trigger"){

        @Override
        public EventSourceItem createEventSourceItem(Annotation eventSource) {
            return new RuleEventSourceItem.Builder().withTargetRule(((RuleEventSource)eventSource).targetRule()).build();
        }

        @Override
        public DependencyItem createDependencyItem(Annotation eventSource) {
            return new DependencyItem.Builder().withResourceName(((RuleEventSource)eventSource).targetRule()).withResourceType(ResourceType.CLOUDWATCH_RULE).build();
        }
    }
    ,
    EVENTBRIDGE_RULE_TRIGGER("eventbridge_rule_trigger"){

        @Override
        public EventSourceItem createEventSourceItem(Annotation eventSource) {
            return new EventBridgeRuleSourceItem.Builder().withTargetRule(((EventBridgeRuleSource)eventSource).targetRule()).build();
        }

        @Override
        public DependencyItem createDependencyItem(Annotation eventSource) {
            return new DependencyItem.Builder().withResourceName(((EventBridgeRuleSource)eventSource).targetRule()).withResourceType(ResourceType.EVENTBRIDGE_RULE).build();
        }
    }
    ,
    DYNAMODB_TRIGGER("dynamodb_trigger"){

        @Override
        public EventSourceItem createEventSourceItem(Annotation eventSource) {
            DynamoDbTriggerEventSource dbTriggerEventSource = (DynamoDbTriggerEventSource)eventSource;
            return new DynamoDbTriggerEventSourceItem.Builder().withTargetTable(dbTriggerEventSource.targetTable()).withBatchSize(dbTriggerEventSource.batchSize()).build();
        }

        @Override
        public DependencyItem createDependencyItem(Annotation eventSource) {
            return new DependencyItem.Builder().withResourceName(((DynamoDbTriggerEventSource)eventSource).targetTable()).withResourceType(ResourceType.DYNAMODB_TABLE).build();
        }
    }
    ,
    S3_TRIGGER("s3_trigger"){

        @Override
        public EventSourceItem createEventSourceItem(Annotation eventSource) {
            S3EventSource s3EventSource = (S3EventSource)eventSource;
            return new S3EventSourceItem.Builder().withTargetBucket(s3EventSource.targetBucket()).withEvents(s3EventSource.events()).build();
        }

        @Override
        public DependencyItem createDependencyItem(Annotation eventSource) {
            return new DependencyItem.Builder().withResourceName(((S3EventSource)eventSource).targetBucket()).withResourceType(ResourceType.S3_BUCKET).build();
        }
    }
    ,
    SNS_TOPIC_TRIGGER("sns_topic_trigger"){

        @Override
        public EventSourceItem createEventSourceItem(Annotation eventSource) {
            SnsEventSource snsEventSource = (SnsEventSource)eventSource;
            return new SnsTriggerEventSourceItem.Builder().withTargetTopic(snsEventSource.targetTopic()).withRegionScope(snsEventSource.regionScope()).build();
        }

        @Override
        public DependencyItem createDependencyItem(Annotation eventSource) {
            return new DependencyItem.Builder().withResourceName(((SnsEventSource)eventSource).targetTopic()).withResourceType(ResourceType.SNS_TOPIC).build();
        }
    }
    ,
    SQS_TRIGGER("sqs_trigger"){

        @Override
        public EventSourceItem createEventSourceItem(Annotation eventSource) {
            SqsTriggerEventSource sqsEventSource = (SqsTriggerEventSource)eventSource;
            return new SqsTriggerEventSourceItem.Builder().withTargetQueue(sqsEventSource.targetQueue()).withBatchSize(sqsEventSource.batchSize()).withFunctionResponseTypes(sqsEventSource.functionResponseTypes()).build();
        }

        @Override
        public DependencyItem createDependencyItem(Annotation eventSource) {
            return new DependencyItem.Builder().withResourceName(((SqsTriggerEventSource)eventSource).targetQueue()).withResourceType(ResourceType.SQS_QUEUE).build();
        }
    };

    String name;

    private EventSourceType(String name) {
        this.name = name;
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    public abstract EventSourceItem createEventSourceItem(Annotation var1);

    public abstract DependencyItem createDependencyItem(Annotation var1);

    public String toString() {
        return "EventSourceType{name='" + this.name + "'}";
    }
}

