/*
 * Decompiled with CFR 0.152.
 */
package com.syndicate.deployment.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.syndicate.deployment.model.ResourceType;
import java.util.Objects;

public class DependencyItem {
    @JsonProperty(value="resource_name")
    private String resourceName;
    @JsonProperty(value="resource_type")
    private ResourceType resourceType;

    private DependencyItem() {
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependencyItem that = (DependencyItem)o;
        return this.resourceName.equals(that.resourceName) && this.resourceType == that.resourceType;
    }

    public int hashCode() {
        int result = this.resourceName.hashCode();
        result = 31 * result + this.resourceType.hashCode();
        return result;
    }

    public String toString() {
        return "DependencyItem{resourceName='" + this.resourceName + "', eventSourceType=" + this.resourceType + "}";
    }

    public static class Builder {
        private final DependencyItem dependencyItem = new DependencyItem();

        public Builder withResourceName(String resourceName) {
            Objects.requireNonNull(resourceName, "ResourceName cannot be null");
            this.dependencyItem.resourceName = resourceName;
            return this;
        }

        public Builder withResourceType(ResourceType resourceType) {
            Objects.requireNonNull(resourceType, "ResourceType cannot be null");
            this.dependencyItem.resourceType = resourceType;
            return this;
        }

        public DependencyItem build() {
            return this.dependencyItem;
        }
    }
}

