/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastools.api.visitors;

import io.github.applecommander.bastools.api.Visitor;
import io.github.applecommander.bastools.api.model.ApplesoftKeyword;
import io.github.applecommander.bastools.api.model.Line;
import io.github.applecommander.bastools.api.model.Program;
import io.github.applecommander.bastools.api.model.Statement;
import io.github.applecommander.bastools.api.model.Token;
import java.util.Iterator;
import java.util.Map;

public class ReassignmentVisitor
implements Visitor {
    private Map<Integer, Integer> reassignments;
    private Program newProgram;

    public ReassignmentVisitor(Map<Integer, Integer> reassignments) {
        this.reassignments = reassignments;
    }

    @Override
    public Program visit(Program program) {
        this.newProgram = new Program();
        program.lines.forEach(l -> {
            Line line = l.accept(this);
            this.newProgram.lines.add(line);
        });
        return this.newProgram;
    }

    @Override
    public Line visit(Line line) {
        Line newLine = new Line(line.lineNumber, this.newProgram);
        line.statements.forEach(s -> {
            Statement statement = s.accept(this);
            newLine.statements.add(statement);
        });
        return newLine;
    }

    @Override
    public Statement visit(Statement statement) {
        boolean trigger = false;
        boolean then = false;
        Statement newStatement = new Statement();
        Iterator<Token> iterator = statement.tokens.iterator();
        while (iterator.hasNext()) {
            Token t;
            Token newToken = t = iterator.next();
            if (trigger || then) {
                if (t.type == Token.Type.NUMBER && this.reassignments.containsKey(t.number.intValue())) {
                    newToken = Token.number(t.line, this.reassignments.get(t.number.intValue()).doubleValue());
                }
                then = false;
            }
            if (!trigger) {
                trigger = t.keyword == ApplesoftKeyword.GOSUB || t.keyword == ApplesoftKeyword.GOTO || t.keyword == ApplesoftKeyword.LIST || t.keyword == ApplesoftKeyword.RUN;
                then = t.keyword == ApplesoftKeyword.THEN;
            }
            newStatement.tokens.add(newToken);
        }
        return newStatement;
    }
}

