/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastools.api.visitors;

import io.github.applecommander.bastools.api.Visitor;
import io.github.applecommander.bastools.api.Visitors;
import io.github.applecommander.bastools.api.model.Line;
import io.github.applecommander.bastools.api.model.Statement;
import io.github.applecommander.bastools.api.model.Token;
import java.io.PrintStream;

public class PrettyPrintVisitor
implements Visitor {
    private PrintStream printStream;

    public PrettyPrintVisitor(Visitors.PrintBuilder builder) {
        this.printStream = builder.getPrintStream();
    }

    @Override
    public Line visit(Line line) {
        boolean first = true;
        for (Statement statement : line.statements) {
            if (first) {
                first = false;
                this.printStream.printf("%5d ", line.lineNumber);
            } else {
                this.printStream.printf("%5s ", ":");
            }
            statement.accept(this);
            this.printStream.println();
        }
        return line;
    }

    @Override
    public Token visit(Token token) {
        switch (token.type) {
            case EOL: {
                this.printStream.print("<EOL>");
                break;
            }
            case COMMENT: {
                this.printStream.printf(" REM %s", token.text);
                break;
            }
            case STRING: {
                this.printStream.printf("\"%s\"", token.text);
                break;
            }
            case KEYWORD: {
                this.printStream.printf(" %s ", token.keyword.text);
                break;
            }
            case IDENT: 
            case SYNTAX: {
                this.printStream.print(token.text);
                break;
            }
            case DIRECTIVE: {
                this.printStream.printf("%s ", token.text);
                break;
            }
            case NUMBER: {
                if (Math.rint(token.number) == token.number) {
                    this.printStream.print(token.number.intValue());
                    break;
                }
                this.printStream.print(token.number);
            }
        }
        return token;
    }
}

