/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastools.api.visitors;

import io.github.applecommander.bastools.api.Visitor;
import io.github.applecommander.bastools.api.model.ApplesoftKeyword;
import io.github.applecommander.bastools.api.model.Statement;
import io.github.applecommander.bastools.api.model.Token;
import java.util.Set;
import java.util.TreeSet;

public class LineNumberTargetCollector
implements Visitor {
    private Set<Integer> targets = new TreeSet<Integer>();

    public Set<Integer> getTargets() {
        return this.targets;
    }

    @Override
    public Statement visit(Statement statement) {
        boolean next = false;
        boolean multiple = false;
        for (Token t : statement.tokens) {
            if (next) {
                if (t.type == Token.Type.NUMBER) {
                    this.targets.add(t.number.intValue());
                }
                next = multiple;
                continue;
            }
            next = t.keyword == ApplesoftKeyword.GOSUB || t.keyword == ApplesoftKeyword.GOTO || t.keyword == ApplesoftKeyword.THEN || t.keyword == ApplesoftKeyword.RUN || t.keyword == ApplesoftKeyword.LIST;
            multiple |= t.keyword == ApplesoftKeyword.LIST || t.keyword == ApplesoftKeyword.ON;
        }
        return statement;
    }
}

