/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastools.api.utils;

import java.util.Arrays;
import java.util.stream.IntStream;

public class Converters {
    private Converters() {
    }

    public static Integer toInteger(String value) {
        if (value == null) {
            return null;
        }
        if (value.startsWith("$")) {
            return Integer.valueOf(value.substring(1), 16);
        }
        if (value.startsWith("0x") || value.startsWith("0X")) {
            return Integer.valueOf(value.substring(2), 16);
        }
        return Integer.valueOf(value);
    }

    public static Boolean toBoolean(String value) {
        if (value == null) {
            return null;
        }
        return "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
    }

    public static IntStream toIntStream(String values) {
        IntStream stream = IntStream.empty();
        for (String range : values.split(";")) {
            if (range.contains("-")) {
                String[] parts = range.split("-");
                int low = Integer.parseInt(parts[0]);
                int high = Integer.parseInt(parts[1]);
                stream = IntStream.concat(stream, IntStream.rangeClosed(low, high));
                continue;
            }
            stream = IntStream.concat(stream, Arrays.asList(range.split(",")).stream().mapToInt(Integer::parseInt));
        }
        return stream;
    }
}

