/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastools.api.shapes.exporters;

import io.github.applecommander.bastools.api.shapes.BitmapShape;
import io.github.applecommander.bastools.api.shapes.Shape;
import io.github.applecommander.bastools.api.shapes.ShapeExporter;
import io.github.applecommander.bastools.api.shapes.ShapeTable;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class TextShapeExporter
implements ShapeExporter {
    private int maxWidth = 80;
    private BorderStrategy borderStrategy = BorderStrategy.BOX_DRAWING;
    private boolean skipEmptyShapes;

    private TextShapeExporter() {
    }

    @Override
    public void export(Shape shape, OutputStream outputStream) {
        Objects.requireNonNull(shape);
        Objects.requireNonNull(outputStream);
        BitmapShape b = shape.toBitmap();
        PrintWriter pw = new PrintWriter(outputStream);
        this.drawTopLine(pw, 1, b.getWidth());
        LinkedList<BitmapShape> bqueue = new LinkedList<BitmapShape>(Arrays.asList(b));
        this.drawRow(pw, bqueue, 1, b.getHeight(), b.getWidth());
        this.drawBottomLine(pw, 1, b.getWidth());
        pw.flush();
    }

    @Override
    public void export(ShapeTable shapeTable, OutputStream outputStream) {
        Objects.requireNonNull(shapeTable);
        Objects.requireNonNull(outputStream);
        List blist = shapeTable.shapes.stream().filter(this::displayThisShape).map(Shape::toBitmap).collect(Collectors.toList());
        int width = blist.stream().mapToInt(BitmapShape::getWidth).max().getAsInt();
        int height = blist.stream().mapToInt(BitmapShape::getHeight).max().getAsInt();
        int columns = Math.min(Math.max(1, this.maxWidth / width), blist.size());
        PrintWriter pw = new PrintWriter(outputStream);
        this.drawTopLine(pw, columns, width);
        LinkedList<BitmapShape> bqueue = new LinkedList<BitmapShape>(blist);
        this.drawRow(pw, bqueue, columns, height, width);
        while (!bqueue.isEmpty()) {
            this.drawDividerLine(pw, columns, width);
            this.drawRow(pw, bqueue, columns, height, width);
        }
        this.drawBottomLine(pw, columns, width);
        pw.flush();
    }

    private boolean displayThisShape(Shape shape) {
        return !this.skipEmptyShapes || !shape.isEmpty();
    }

    private void drawTopLine(PrintWriter pw, int columns, int width) {
        this.borderStrategy.topLeftCorner(pw);
        this.borderStrategy.horizontalLine(pw, width);
        for (int i = 1; i < columns; ++i) {
            this.borderStrategy.topDivider(pw);
            this.borderStrategy.horizontalLine(pw, width);
        }
        this.borderStrategy.topRightCorner(pw);
    }

    private void drawDividerLine(PrintWriter pw, int columns, int width) {
        this.borderStrategy.dividerLeftEdge(pw);
        this.borderStrategy.dividerHorizontalLine(pw, width);
        for (int i = 1; i < columns; ++i) {
            this.borderStrategy.dividerMiddle(pw);
            this.borderStrategy.dividerHorizontalLine(pw, width);
        }
        this.borderStrategy.dividerRightEdge(pw);
    }

    private void drawBottomLine(PrintWriter pw, int columns, int width) {
        this.borderStrategy.bottomLeftCorner(pw);
        this.borderStrategy.horizontalLine(pw, width);
        for (int i = 1; i < columns; ++i) {
            this.borderStrategy.bottomDivider(pw);
            this.borderStrategy.horizontalLine(pw, width);
        }
        this.borderStrategy.bottomRightCorner(pw);
    }

    private void drawRow(PrintWriter pw, Queue<BitmapShape> bqueue, int columns, int height, int width) {
        BitmapShape[] bshapes = new BitmapShape[columns];
        for (int i = 0; i < bshapes.length; ++i) {
            bshapes[i] = bqueue.isEmpty() ? new BitmapShape() : bqueue.remove();
        }
        for (int y = 0; y < height; ++y) {
            this.borderStrategy.verticalLine(pw);
            this.drawRowLine(pw, bshapes[0], width, y);
            for (int c = 1; c < bshapes.length; ++c) {
                this.borderStrategy.dividerVerticalLine(pw);
                this.drawRowLine(pw, bshapes[c], width, y);
            }
            this.borderStrategy.verticalLine(pw);
            pw.println();
        }
    }

    private void drawRowLine(PrintWriter pw, BitmapShape bshape, int width, int y) {
        ArrayList row = bshape.grid.size() > y ? bshape.grid.get(y) : new ArrayList();
        for (int x = 0; x < width; ++x) {
            if (row.size() > x) {
                Boolean plot = (Boolean)row.get(x);
                if (bshape.origin.x == x && bshape.origin.y == y) {
                    pw.printf("%c", Character.valueOf(plot != false ? (char)'*' : '+'));
                    continue;
                }
                pw.printf("%c", Character.valueOf(plot != false ? (char)'X' : '.'));
                continue;
            }
            pw.print(" ");
        }
    }

    public static class Builder {
        private TextShapeExporter textShapeExporter = new TextShapeExporter();

        public Builder maxWidth(int maxWidth) {
            this.textShapeExporter.maxWidth = maxWidth;
            return this;
        }

        public Builder noBorder() {
            return this.borderStrategy(BorderStrategy.NONE);
        }

        public Builder asciiTextBorder() {
            return this.borderStrategy(BorderStrategy.ASCII_TEXT);
        }

        public Builder boxDrawingBorder() {
            return this.borderStrategy(BorderStrategy.BOX_DRAWING);
        }

        public Builder borderStrategy(BorderStrategy borderStrategy) {
            this.textShapeExporter.borderStrategy = borderStrategy;
            return this;
        }

        public Builder skipEmptyShapes() {
            return this.skipEmptyShapes(true);
        }

        public Builder skipEmptyShapes(boolean skipEmptyShapes) {
            this.textShapeExporter.skipEmptyShapes = skipEmptyShapes;
            return this;
        }

        public ShapeExporter build() {
            return this.textShapeExporter;
        }
    }

    public static enum BorderStrategy {
        NONE('\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', ' ', '\u0000', '\n', '\u0000', '\u0000'),
        BOX_DRAWING('\u2500', '\u2502', '\u250c', '\u2510', '\u2514', '\u2518', '\u252c', '\u2534', '\u2502', '\u2500', '\u251c', '\u2524', '\u253c'),
        ASCII_TEXT('-', '|', '+', '+', '+', '+', '+', '+', '|', '-', '+', '+', '+');

        private final char horizontalLine;
        private final char verticalLine;
        private final char topLeftCorner;
        private final char topRightCorner;
        private final char bottomLeftCorner;
        private final char bottomRightCorner;
        private final char topDivider;
        private final char bottomDivider;
        private final char dividerVerticalLine;
        private final char dividerHorizontalLine;
        private final char dividerLeftEdge;
        private final char dividerRightEdge;
        private final char dividerMiddle;

        private BorderStrategy(char horizontalLine, char verticalLine, char topLeftCorner, char topRightCorner, char bottomLeftCorner, char bottomRightCorner, char topDivider, char bottomDivider, char dividerVerticalLine, char dividerHorizontalLine, char dividerLeftEdge, char dividerRightEdge, char dividerMiddle) {
            this.horizontalLine = horizontalLine;
            this.verticalLine = verticalLine;
            this.topLeftCorner = topLeftCorner;
            this.topRightCorner = topRightCorner;
            this.bottomLeftCorner = bottomLeftCorner;
            this.bottomRightCorner = bottomRightCorner;
            this.topDivider = topDivider;
            this.bottomDivider = bottomDivider;
            this.dividerVerticalLine = dividerVerticalLine;
            this.dividerHorizontalLine = dividerHorizontalLine;
            this.dividerLeftEdge = dividerLeftEdge;
            this.dividerRightEdge = dividerRightEdge;
            this.dividerMiddle = dividerMiddle;
        }

        private void print(Consumer<String> output, char ch) {
            this.print(output, ch, 1);
        }

        private void print(Consumer<String> output, char ch, int width) {
            if (ch != '\u0000') {
                output.accept(new String(new char[width]).replace('\u0000', ch));
            }
        }

        public void horizontalLine(PrintWriter pw, int width) {
            this.print(pw::print, this.horizontalLine, width);
        }

        public void verticalLine(PrintWriter pw) {
            this.print(pw::print, this.verticalLine);
        }

        public void topLeftCorner(PrintWriter pw) {
            this.print(pw::print, this.topLeftCorner);
        }

        public void topRightCorner(PrintWriter pw) {
            this.print(pw::println, this.topRightCorner);
        }

        public void bottomLeftCorner(PrintWriter pw) {
            this.print(pw::print, this.bottomLeftCorner);
        }

        public void bottomRightCorner(PrintWriter pw) {
            this.print(pw::println, this.bottomRightCorner);
        }

        public void topDivider(PrintWriter pw) {
            this.print(pw::print, this.topDivider);
        }

        public void bottomDivider(PrintWriter pw) {
            this.print(pw::print, this.bottomDivider);
        }

        public void dividerVerticalLine(PrintWriter pw) {
            this.print(pw::print, this.dividerVerticalLine);
        }

        public void dividerHorizontalLine(PrintWriter pw, int width) {
            this.print(pw::print, this.dividerHorizontalLine, width);
        }

        public void dividerLeftEdge(PrintWriter pw) {
            this.print(pw::print, this.dividerLeftEdge);
        }

        public void dividerRightEdge(PrintWriter pw) {
            this.print(pw::println, this.dividerRightEdge);
        }

        public void dividerMiddle(PrintWriter pw) {
            this.print(pw::print, this.dividerMiddle);
        }
    }
}

