/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastools.api.shapes.exporters;

import io.github.applecommander.bastools.api.shapes.Shape;
import io.github.applecommander.bastools.api.shapes.ShapeExporter;
import io.github.applecommander.bastools.api.shapes.ShapeTable;
import io.github.applecommander.bastools.api.shapes.VectorCommand;
import io.github.applecommander.bastools.api.shapes.VectorShape;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.BiConsumer;

public class SourceShapeExporter
implements ShapeExporter {
    private BiConsumer<Shape, PrintWriter> formatFunction = this::exportShapeAsBitmap;
    private ShapeExporter textExporter = ShapeExporter.text().noBorder().build();
    private boolean skipEmptyShapes;
    private boolean optimize;

    private SourceShapeExporter() {
    }

    @Override
    public void export(Shape shape, OutputStream outputStream) throws IOException {
        PrintWriter pw = new PrintWriter(outputStream);
        this.formatFunction.accept(shape, pw);
        pw.flush();
    }

    @Override
    public void export(ShapeTable shapeTable, OutputStream outputStream) throws IOException {
        PrintWriter pw = new PrintWriter(outputStream);
        shapeTable.shapes.stream().filter(this::displayThisShape).forEach(shape -> this.formatFunction.accept((Shape)shape, pw));
        pw.flush();
    }

    private boolean displayThisShape(Shape shape) {
        return !this.skipEmptyShapes || !shape.isEmpty();
    }

    public void exportShapeAsBitmap(Shape shape, PrintWriter pw) {
        try {
            pw.printf(".bitmap\n", new Object[0]);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.textExporter.export(shape, (OutputStream)new PaddedOutputStream(os, "  "));
            pw.print(new String(os.toByteArray()));
            pw.printf("\n", new Object[0]);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public void exportShapeAsShortCommands(Shape shape, PrintWriter pw) {
        VectorShape vshape = shape.toVector();
        if (this.optimize) {
            vshape = vshape.optimize();
        }
        if (this.displayThisShape(vshape)) {
            pw.printf(".short\n", new Object[0]);
            pw.printf("  %s\n", vshape.toShortCommands());
            pw.printf("\n", new Object[0]);
        }
    }

    public void exportShapeAsLongCommands(Shape shape, PrintWriter pw) {
        VectorShape vshape = shape.toVector();
        if (this.optimize) {
            vshape = vshape.optimize();
        }
        if (this.displayThisShape(vshape)) {
            pw.printf(".long\n", new Object[0]);
            LinkedList<VectorCommand> vectors = new LinkedList<VectorCommand>(vshape.vectors);
            while (!vectors.isEmpty()) {
                VectorCommand vector = (VectorCommand)((Object)vectors.remove());
                int count = 1;
                while (vectors.peek() == vector) {
                    vectors.remove();
                    ++count;
                }
                if (count == 1) {
                    pw.printf("  %s\n", vector.longCommand);
                    continue;
                }
                pw.printf("  %s %d\n", vector.longCommand, count);
            }
            pw.printf("\n", new Object[0]);
        }
    }

    public static class PaddedOutputStream
    extends OutputStream {
        private OutputStream wrappedStream;
        private boolean needPadding = true;
        private byte[] padding;

        public PaddedOutputStream(OutputStream outputStream, String padding) {
            Objects.requireNonNull(outputStream);
            Objects.requireNonNull(padding);
            this.wrappedStream = outputStream;
            this.padding = padding.getBytes();
        }

        @Override
        public void write(int b) throws IOException {
            if (this.needPadding) {
                this.wrappedStream.write(this.padding);
            }
            this.needPadding = b == 10;
            this.wrappedStream.write(b);
        }
    }

    public static class Builder {
        private SourceShapeExporter exporter = new SourceShapeExporter();

        public Builder bitmap() {
            this.exporter.formatFunction = this.exporter::exportShapeAsBitmap;
            return this;
        }

        public Builder shortCommands() {
            this.exporter.formatFunction = this.exporter::exportShapeAsShortCommands;
            return this;
        }

        public Builder longCommands() {
            this.exporter.formatFunction = this.exporter::exportShapeAsLongCommands;
            return this;
        }

        public Builder skipEmptyShapes() {
            return this.skipEmptyShapes(true);
        }

        public Builder skipEmptyShapes(boolean skipEmptyShapes) {
            this.exporter.skipEmptyShapes = skipEmptyShapes;
            return this;
        }

        public Builder optimize() {
            return this.optimize(true);
        }

        public Builder optimize(boolean optimize) {
            this.exporter.optimize = optimize;
            return this;
        }

        public ShapeExporter build() {
            return this.exporter;
        }
    }
}

