/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastools.api.shapes;

import io.github.applecommander.bastools.api.shapes.BitmapShape;
import io.github.applecommander.bastools.api.shapes.Shape;
import io.github.applecommander.bastools.api.shapes.VectorCommand;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VectorShape
implements Shape {
    public final String label;
    public final List<VectorCommand> vectors = new ArrayList<VectorCommand>();

    public static VectorShape from(ByteBuffer buf) {
        int code;
        Objects.requireNonNull(buf);
        VectorShape shape = new VectorShape();
        VectorCommand[] commands = VectorCommand.values();
        while (buf.hasRemaining() && (code = Byte.toUnsignedInt(buf.get())) != 0) {
            int vector1 = code & 7;
            int vector2 = code >> 3 & 7;
            int vector3 = code >> 6 & 3;
            shape.vectors.add(commands[vector1]);
            if (vector2 == 0 && vector3 == 0) continue;
            shape.vectors.add(commands[vector2]);
            if (vector3 == 0) continue;
            shape.vectors.add(commands[vector3]);
        }
        return shape;
    }

    public VectorShape() {
        this.label = null;
    }

    public VectorShape(String label) {
        this.label = label;
    }

    public VectorShape moveUp() {
        return this.append(VectorCommand.MOVE_UP);
    }

    public VectorShape moveRight() {
        return this.append(VectorCommand.MOVE_RIGHT);
    }

    public VectorShape moveDown() {
        return this.append(VectorCommand.MOVE_DOWN);
    }

    public VectorShape moveLeft() {
        return this.append(VectorCommand.MOVE_LEFT);
    }

    public VectorShape plotUp() {
        return this.append(VectorCommand.PLOT_UP);
    }

    public VectorShape plotRight() {
        return this.append(VectorCommand.PLOT_RIGHT);
    }

    public VectorShape plotDown() {
        return this.append(VectorCommand.PLOT_DOWN);
    }

    public VectorShape plotLeft() {
        return this.append(VectorCommand.PLOT_LEFT);
    }

    public VectorShape append(VectorCommand vectorCommand) {
        this.vectors.add(vectorCommand);
        return this;
    }

    public VectorShape optimize() {
        String commands = this.toShortCommands();
        Function<String, String> opts = VectorRegexOptimization.of("l([ud]*)r").andThen(VectorRegexOptimization.of("r([ud]*)l")).andThen(VectorRegexOptimization.of("u([rl]*)d")).andThen(VectorRegexOptimization.of("d([rl]*)u")).andThen(VectorRegexOptimization.of("L([ud])r", String::toUpperCase)).andThen(VectorRegexOptimization.of("R([ud])l", String::toUpperCase)).andThen(VectorRegexOptimization.of("U([rl])d", String::toUpperCase)).andThen(VectorRegexOptimization.of("D([rl])u", String::toUpperCase)).andThen(VectorRegexOptimization.of("()[udlr]+$"));
        String oldCommands = null;
        while (!(oldCommands = commands).equals(commands = opts.apply(commands))) {
        }
        VectorShape newShape = new VectorShape();
        newShape.appendShortCommands(commands);
        return newShape;
    }

    public String toShortCommands() {
        StringBuilder sb = new StringBuilder();
        this.vectors.stream().map(v -> Character.valueOf(v.shortCommand)).forEach(sb::append);
        return sb.toString();
    }

    public void appendShortCommands(String line) {
        for (char cmd : line.trim().toCharArray()) {
            this.appendShortCommand(cmd);
        }
    }

    public void appendShortCommand(char cmd) {
        switch (cmd) {
            case 'u': {
                this.moveUp();
                break;
            }
            case 'd': {
                this.moveDown();
                break;
            }
            case 'l': {
                this.moveLeft();
                break;
            }
            case 'r': {
                this.moveRight();
                break;
            }
            case 'U': {
                this.plotUp();
                break;
            }
            case 'D': {
                this.plotDown();
                break;
            }
            case 'L': {
                this.plotLeft();
                break;
            }
            case 'R': {
                this.plotRight();
                break;
            }
            default: {
                if (Character.isWhitespace(cmd)) break;
                throw new RuntimeException("Unknown command: " + cmd);
            }
        }
    }

    public void appendLongCommands(String line) {
        LinkedList<String> tokens = new LinkedList<String>(Arrays.asList(line.split("\\s+")));
        while (!tokens.isEmpty()) {
            String command = (String)tokens.remove();
            int count = 1;
            String checkNumber = (String)tokens.peek();
            if (checkNumber != null && checkNumber.matches("\\d+")) {
                count = Integer.parseInt((String)tokens.remove());
            }
            block21: for (int i = 0; i < count; ++i) {
                switch (command.toLowerCase()) {
                    case "moveup": {
                        this.moveUp();
                        continue block21;
                    }
                    case "movedown": {
                        this.moveDown();
                        continue block21;
                    }
                    case "moveleft": {
                        this.moveLeft();
                        continue block21;
                    }
                    case "moveright": {
                        this.moveRight();
                        continue block21;
                    }
                    case "plotup": {
                        this.plotUp();
                        continue block21;
                    }
                    case "plotdown": {
                        this.plotDown();
                        continue block21;
                    }
                    case "plotleft": {
                        this.plotLeft();
                        continue block21;
                    }
                    case "plotright": {
                        this.plotRight();
                        continue block21;
                    }
                    default: {
                        throw new RuntimeException("Unknown command: " + command);
                    }
                }
            }
        }
    }

    public byte[] toBytes() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        LinkedList<VectorCommand> work = new LinkedList<VectorCommand>(this.vectors);
        while (!work.isEmpty()) {
            int section3;
            VectorCommand vector1 = work.remove();
            int section1 = vector1.ordinal();
            VectorCommand vector2 = work.poll();
            int section2 = Optional.ofNullable(vector2).map(Enum::ordinal).orElse(0);
            VectorCommand vector3 = work.poll();
            if (vector3 != null && (vector3.plot || vector3 == VectorCommand.MOVE_UP)) {
                work.addFirst(vector3);
                vector3 = null;
            }
            if ((section3 = Optional.ofNullable(vector3).map(Enum::ordinal).orElse(0).intValue()) == 0 && section2 == 0 && !work.isEmpty()) {
                VectorCommand test;
                vector3 = VectorCommand.MOVE_LEFT;
                section3 = vector3.ordinal();
                int moveUpCount = 0;
                Iterator iterator = work.iterator();
                while (iterator.hasNext() && (test = (VectorCommand)((Object)iterator.next())) == VectorCommand.MOVE_UP) {
                    ++moveUpCount;
                }
                work.add(Math.min(moveUpCount, 2), VectorCommand.MOVE_RIGHT);
            }
            outputStream.write(section3 << 6 | section2 << 3 | section1);
        }
        outputStream.write(0);
        return outputStream.toByteArray();
    }

    @Override
    public boolean isEmpty() {
        return this.vectors.isEmpty();
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public BitmapShape toBitmap() {
        BitmapShape shape = new BitmapShape();
        int x = 0;
        int y = 0;
        for (VectorCommand command : this.vectors) {
            if (command.plot) {
                while (y < 0) {
                    shape.insertRow();
                    ++y;
                }
                while (y >= shape.getHeight()) {
                    shape.addRow();
                }
                while (x < 0) {
                    shape.insertColumn();
                    ++x;
                }
                while (x >= shape.getWidth()) {
                    shape.addColumn();
                }
                shape.plot(x, y);
            }
            x += command.xmove;
            y += command.ymove;
        }
        return shape;
    }

    @Override
    public VectorShape toVector() {
        return this;
    }

    public static class VectorRegexOptimization
    implements Function<String, String> {
        private Pattern pattern;
        private Function<String, String> fn;

        public static Function<String, String> of(String regex, Function<String, String> transformation) {
            VectorRegexOptimization opt = new VectorRegexOptimization();
            opt.pattern = Pattern.compile(regex);
            opt.fn = transformation;
            return opt;
        }

        public static Function<String, String> of(String regex) {
            return VectorRegexOptimization.of(regex, s -> s);
        }

        private VectorRegexOptimization() {
        }

        @Override
        public String apply(String shortCommands) {
            Matcher matcher = this.pattern.matcher(shortCommands);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(sb, this.fn.apply(matcher.group(1)));
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
    }
}

