/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastools.api.shapes;

public enum VectorCommand {
    MOVE_UP,
    MOVE_RIGHT,
    MOVE_DOWN,
    MOVE_LEFT,
    PLOT_UP,
    PLOT_RIGHT,
    PLOT_DOWN,
    PLOT_LEFT;

    public final boolean plot;
    public final int xmove;
    public final int ymove;
    public final char shortCommand;
    public final String longCommand;
    public final boolean vertical;
    public final boolean horizontal;

    private VectorCommand() {
        boolean bl = this.plot = (this.ordinal() & 4) != 0;
        if ((this.ordinal() & 1) == 1) {
            this.xmove = 2 - (this.ordinal() & 3);
            this.ymove = 0;
        } else {
            this.xmove = 0;
            this.ymove = (this.ordinal() & 3) - 1;
        }
        this.vertical = this.xmove == 0;
        this.horizontal = this.ymove == 0;
        char shortCommand = "urdl".charAt(this.ordinal() & 3);
        this.shortCommand = this.plot ? Character.toUpperCase(shortCommand) : shortCommand;
        this.longCommand = this.name().replaceAll("_", "").toLowerCase();
    }

    public VectorCommand opposite() {
        int newDirection = this.ordinal() ^ 2;
        return VectorCommand.values()[newDirection];
    }

    public VectorCommand plot() {
        return VectorCommand.values()[this.ordinal() | 4];
    }

    public VectorCommand move() {
        return VectorCommand.values()[this.ordinal() & 3];
    }
}

